/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberHandler;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Type;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class GizmoMethodHandler
implements GizmoMemberHandler {
    final Class<?> declaringClass;
    final MethodDesc methodDescriptor;

    GizmoMethodHandler(Class<?> declaringClass, MethodDesc methodDescriptor) {
        this.declaringClass = declaringClass;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public void whenIsField(Consumer<FieldDesc> fieldDescriptorConsumer) {
    }

    @Override
    public void whenIsMethod(Consumer<MethodDesc> methodDescriptorConsumer) {
        methodDescriptorConsumer.accept(this.methodDescriptor);
    }

    @Override
    public Expr readMemberValue(BlockCreator bytecodeCreator, Expr thisObj) {
        return GizmoMethodHandler.invokeMemberMethod(this.declaringClass, bytecodeCreator, this.methodDescriptor, thisObj, new Expr[0]);
    }

    @Override
    public Expr readMemberValue(BlockCreator bytecodeCreator, Expr thisObj, Expr parameter) {
        throw new IllegalStateException("Cannot pass a parameter when invoking the method.");
    }

    @Override
    public boolean writeMemberValue(MethodDesc setter, BlockCreator bytecodeCreator, Expr thisObj, Expr newValue) {
        if (setter == null) {
            return false;
        }
        GizmoMethodHandler.invokeMemberMethod(this.declaringClass, bytecodeCreator, setter, thisObj, newValue);
        return true;
    }

    static Expr invokeMemberMethod(Class<?> declaringClass, BlockCreator creator, MethodDesc method, Expr bean, Expr ... parameters) {
        if (declaringClass.isInterface()) {
            InterfaceMethodDesc interfaceMethod = InterfaceMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(declaringClass.descriptorString()), (String)method.name(), (MethodTypeDesc)method.type());
            return creator.invokeInterface((MethodDesc)interfaceMethod, bean, parameters);
        }
        return creator.invokeVirtual(method, bean, parameters);
    }

    @Override
    public String getDeclaringClassName() {
        return GizmoMemberHandler.getTypeName(this.methodDescriptor.owner());
    }

    @Override
    public String getTypeName() {
        return GizmoMemberHandler.getTypeName(this.methodDescriptor.returnType());
    }

    @Override
    public Type getType() {
        try {
            return this.declaringClass.getDeclaredMethod(this.methodDescriptor.name(), new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find method (%s) on class (%s).".formatted(this.methodDescriptor.name(), this.declaringClass), e);
        }
    }

    public String toString() {
        return this.methodDescriptor.toString();
    }
}

