/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberHandler;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;

public final class GizmoMemberDescriptor {
    private final String name;
    private final Type methodParameterType;
    private final GizmoMemberHandler memberHandler;
    private final GizmoMemberHandler metadataHandler;
    private final MethodDesc setter;

    public GizmoMemberDescriptor(Member member) {
        this(member, false);
    }

    public GizmoMemberDescriptor(Member member, boolean methodWithParameter) {
        Class<?> declaringClass = member.getDeclaringClass();
        if (!Modifier.isPublic(member.getModifiers())) {
            throw new IllegalStateException("Member (%s) of class (%s) is not public and domainAccessType is %s.\n%sMaybe use domainAccessType %s instead of %s.".formatted(new Object[]{member.getName(), member.getDeclaringClass().getName(), DomainAccessType.GIZMO, member instanceof Field ? "Maybe put the annotations onto the public getter of the field.\n" : "", DomainAccessType.REFLECTION, DomainAccessType.GIZMO}));
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            FieldDesc fieldDescriptor = FieldDesc.of((Field)field);
            this.name = member.getName();
            this.memberHandler = GizmoMemberHandler.of(declaringClass, this.name, fieldDescriptor, false);
            this.setter = null;
            this.methodParameterType = null;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            MethodDesc methodDescriptor = MethodDesc.of((Method)method);
            this.name = ReflectionHelper.isGetterMethod(method) ? ReflectionHelper.getGetterPropertyName(member) : member.getName();
            this.methodParameterType = GizmoMemberDescriptor.getMethodParameterType(method, methodWithParameter);
            this.memberHandler = GizmoMemberHandler.of(declaringClass, (Class)this.methodParameterType, methodDescriptor);
            this.setter = GizmoMemberDescriptor.lookupSetter(methodDescriptor, declaringClass, this.name).orElse(null);
        } else {
            throw new IllegalArgumentException("%s is not a Method or a Field.".formatted(member));
        }
        this.metadataHandler = this.memberHandler;
    }

    public GizmoMemberDescriptor(String name, FieldDesc fieldDescriptor, Class<?> declaringClass) {
        this.name = name;
        this.metadataHandler = this.memberHandler = GizmoMemberHandler.of(declaringClass, name, fieldDescriptor, true);
        this.setter = null;
        this.methodParameterType = null;
    }

    public GizmoMemberDescriptor(String name, MethodDesc memberDescriptor, MethodDesc metadataDescriptor, Type methodParameterType, Class<?> declaringClass, MethodDesc setterDescriptor) {
        this.name = name;
        this.memberHandler = GizmoMemberHandler.of(declaringClass, (Class)methodParameterType, memberDescriptor);
        this.metadataHandler = memberDescriptor == metadataDescriptor ? this.memberHandler : GizmoMemberHandler.of(declaringClass, metadataDescriptor);
        this.methodParameterType = methodParameterType;
        this.setter = setterDescriptor;
    }

    public GizmoMemberDescriptor(String name, MethodDesc memberDescriptor, Type methodParameterType, Class<?> declaringClass, MethodDesc setterDescriptor) {
        this.name = name;
        this.metadataHandler = this.memberHandler = GizmoMemberHandler.of(declaringClass, (Class)methodParameterType, memberDescriptor);
        this.methodParameterType = methodParameterType;
        this.setter = setterDescriptor;
    }

    public GizmoMemberDescriptor(String name, MethodDesc memberDescriptor, FieldDesc metadataDescriptor, Type methodParameterType, Class<?> declaringClass, MethodDesc setterDescriptor) {
        this.name = name;
        this.memberHandler = GizmoMemberHandler.of(declaringClass, (Class)methodParameterType, memberDescriptor);
        this.metadataHandler = GizmoMemberHandler.of(declaringClass, name, metadataDescriptor, true);
        this.methodParameterType = methodParameterType;
        this.setter = setterDescriptor;
    }

    public static Type getMethodParameterType(Method method, boolean methodWithParameter) {
        int parameterCount = method.getParameterCount();
        Class<?> methodParameterType = null;
        if (methodWithParameter && parameterCount == 1) {
            methodParameterType = method.getParameterTypes()[0];
        }
        if (methodWithParameter && parameterCount > 1) {
            throw new IllegalStateException("The getterMethod (%s) must have only one parameter (%s).".formatted(method.getName(), Arrays.toString(method.getParameterTypes())));
        }
        if (parameterCount == 1) {
            return methodParameterType;
        }
        return null;
    }

    public GizmoMemberDescriptor whenIsField(Consumer<FieldDesc> fieldDescriptorConsumer) {
        this.memberHandler.whenIsField(fieldDescriptorConsumer);
        return this;
    }

    public GizmoMemberDescriptor whenIsMethod(Consumer<MethodDesc> methodDescriptorConsumer) {
        this.memberHandler.whenIsMethod(methodDescriptorConsumer);
        return this;
    }

    public Expr readMemberValue(BlockCreator bytecodeCreator, Expr thisObj) {
        return this.memberHandler.readMemberValue(bytecodeCreator, thisObj);
    }

    public Expr readMemberValue(BlockCreator bytecodeCreator, Expr thisObj, Expr parameter) {
        return this.memberHandler.readMemberValue(bytecodeCreator, thisObj, parameter);
    }

    public boolean writeMemberValue(BlockCreator bytecodeCreator, Expr thisObj, Expr newValue) {
        return this.memberHandler.writeMemberValue(this.setter, bytecodeCreator, thisObj, newValue);
    }

    public GizmoMemberDescriptor whenMetadataIsOnField(Consumer<FieldDesc> fieldDescriptorConsumer) {
        this.metadataHandler.whenIsField(fieldDescriptorConsumer);
        return this;
    }

    public GizmoMemberDescriptor whenMetadataIsOnMethod(Consumer<MethodDesc> methodDescriptorConsumer) {
        this.metadataHandler.whenIsMethod(methodDescriptorConsumer);
        return this;
    }

    public String getDeclaringClassName() {
        return this.memberHandler.getDeclaringClassName();
    }

    public Optional<MethodDesc> getSetter() {
        return Optional.ofNullable(this.setter);
    }

    private static Optional<MethodDesc> lookupSetter(Object memberDescriptor, Class<?> declaringClass, String name) {
        if (memberDescriptor instanceof MethodDesc) {
            return Optional.ofNullable(ReflectionHelper.getSetterMethod(declaringClass, name)).map(MethodDesc::of);
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.metadataHandler.getTypeName();
    }

    public Type getType() {
        return this.metadataHandler.getType();
    }

    public Type getMethodParameterType() {
        return this.methodParameterType;
    }

    public String toString() {
        return this.memberHandler.toString();
    }
}

