/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractReadOnlyExtendedGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractReadOnlyGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractReadWriteExtendedGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AbstractReadWriteGizmoMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AccessorInfo;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberInfo;
import ai.timefold.solver.core.impl.util.MutableReference;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.This;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.NonNull;

public final class GizmoMemberAccessorImplementor {
    public static void defineAccessorFor(String className, ClassOutput classOutput, GizmoMemberInfo memberInfo) {
        Class<? extends AbstractGizmoMemberAccessor> superClass = GizmoMemberAccessorImplementor.getCorrectSuperclass(memberInfo);
        Gizmo gizmo = Gizmo.create((ClassOutput)classOutput);
        gizmo.class_(className, classCreator -> {
            classCreator.final_();
            classCreator.extends_(superClass);
            FieldDesc genericType = classCreator.field("genericType", fieldCreator -> {
                fieldCreator.final_();
                fieldCreator.setType(Type.class);
            });
            FieldDesc methodParameterType = null;
            if (memberInfo.readMethodWithParameter()) {
                methodParameterType = classCreator.field("readMethodParameterType", fieldCreator -> {
                    fieldCreator.final_();
                    fieldCreator.setType(Type.class);
                    fieldCreator.setInitial((Class)memberInfo.descriptor().getMethodParameterType());
                });
            }
            FieldDesc annotatedElement = classCreator.field("annotatedElement", fieldCreator -> {
                fieldCreator.final_();
                fieldCreator.setType(AnnotatedElement.class);
            });
            GeneratedClassInfo generatedClassInfo = new GeneratedClassInfo((ClassCreator)classCreator, genericType, methodParameterType, annotatedElement, memberInfo);
            GizmoMemberAccessorImplementor.createConstructor(generatedClassInfo);
            GizmoMemberAccessorImplementor.createGetName(generatedClassInfo);
            GizmoMemberAccessorImplementor.createGetDeclaringClass(generatedClassInfo);
            GizmoMemberAccessorImplementor.createGetType(generatedClassInfo);
            GizmoMemberAccessorImplementor.createGetGenericType(generatedClassInfo);
            if (superClass == AbstractReadWriteExtendedGizmoMemberAccessor.class || superClass == AbstractReadOnlyExtendedGizmoMemberAccessor.class) {
                GizmoMemberAccessorImplementor.createGetGetterMethodParameterType(generatedClassInfo);
                GizmoMemberAccessorImplementor.createExecuteGetterWithParameter(generatedClassInfo);
            } else {
                GizmoMemberAccessorImplementor.createExecuteGetter(generatedClassInfo);
            }
            if (superClass == AbstractReadWriteGizmoMemberAccessor.class || superClass == AbstractReadWriteExtendedGizmoMemberAccessor.class) {
                GizmoMemberAccessorImplementor.createExecuteSetter(generatedClassInfo);
            }
            GizmoMemberAccessorImplementor.createGetAnnotation(generatedClassInfo);
            GizmoMemberAccessorImplementor.createDeclaredAnnotationsByType(generatedClassInfo);
        });
    }

    private static Class<? extends AbstractGizmoMemberAccessor> getCorrectSuperclass(GizmoMemberInfo memberInfo) {
        AtomicBoolean supportsSetter = new AtomicBoolean();
        AtomicBoolean methodWithParameter = new AtomicBoolean();
        memberInfo.descriptor().whenIsMethod(method -> {
            supportsSetter.set(memberInfo.descriptor().getSetter().isPresent());
            methodWithParameter.set(memberInfo.readMethodWithParameter());
        });
        memberInfo.descriptor().whenIsField(field -> {
            supportsSetter.set(true);
            methodWithParameter.set(false);
        });
        if (supportsSetter.get()) {
            return methodWithParameter.get() ? AbstractReadWriteExtendedGizmoMemberAccessor.class : AbstractReadWriteGizmoMemberAccessor.class;
        }
        return methodWithParameter.get() ? AbstractReadOnlyExtendedGizmoMemberAccessor.class : AbstractReadOnlyGizmoMemberAccessor.class;
    }

    static MemberAccessor createAccessorFor(Member member, Class<? extends Annotation> annotationClass, AccessorInfo accessorInfo, GizmoClassLoader gizmoClassLoader) {
        String className = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        if (gizmoClassLoader.hasBytecodeFor(className)) {
            return GizmoMemberAccessorImplementor.createInstance(className, gizmoClassLoader);
        }
        MutableReference<@NonNull Object> classBytecodeHolder = new MutableReference<Object>(null);
        ClassOutput classOutput = (path, byteCode) -> classBytecodeHolder.setValue(byteCode);
        GizmoMemberDescriptor descriptor = new GizmoMemberDescriptor(member, accessorInfo.readMethodWithParameter());
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(descriptor, accessorInfo.returnTypeRequired(), descriptor.getMethodParameterType() != null, annotationClass);
        GizmoMemberAccessorImplementor.defineAccessorFor(className, classOutput, memberInfo);
        byte[] classBytecode = classBytecodeHolder.getValue();
        gizmoClassLoader.storeBytecode(className, classBytecode);
        return GizmoMemberAccessorImplementor.createInstance(className, gizmoClassLoader);
    }

    private static MemberAccessor createInstance(String className, GizmoClassLoader gizmoClassLoader) {
        try {
            return (MemberAccessor)gizmoClassLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createConstructor(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.constructor(constructorCreator -> constructorCreator.body(blockCreator -> {
            This thisObj = constructorCreator.this_();
            blockCreator.invokeSpecial(ConstructorDesc.of((ClassDesc)classCreator.superClass()), (Expr)thisObj);
            LocalVar declaringClass = blockCreator.localVar("declaringClass", (Expr)Const.of((ClassDesc)ClassDesc.of(memberInfo.descriptor().getDeclaringClassName())));
            memberInfo.descriptor().whenMetadataIsOnField(md -> {
                Const name = Const.of((String)md.name());
                LocalVar field = blockCreator.localVar("declaredField", blockCreator.invokeVirtual(MethodDesc.of(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), (Expr)declaringClass, (Expr)name));
                Expr type = blockCreator.invokeVirtual(MethodDesc.of(Field.class, (String)"getGenericType", Type.class, (Class[])new Class[0]), (Expr)field);
                blockCreator.set((Assignable)thisObj.field(generatedClassInfo.genericTypeField), type);
                blockCreator.set((Assignable)thisObj.field(generatedClassInfo.annotatedElementField), (Expr)field);
            });
            memberInfo.descriptor().whenMetadataIsOnMethod(md -> {
                Const name = Const.of((String)md.name());
                Expr parameterArray = generatedClassInfo.readMethodParameterTypeField() != null ? blockCreator.newArray(Class.class, new Expr[]{Const.of((Class)((Class)generatedClassInfo.memberInfo.descriptor().getMethodParameterType()))}) : blockCreator.newEmptyArray(Class.class, 0);
                LocalVar method = blockCreator.localVar("method", blockCreator.invokeVirtual(MethodDesc.of(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), (Expr)declaringClass, (Expr)name, parameterArray));
                if (memberInfo.returnTypeRequired()) {
                    Expr type = blockCreator.invokeVirtual(MethodDesc.of(Method.class, (String)"getGenericReturnType", Type.class, (Class[])new Class[0]), (Expr)method);
                    blockCreator.set((Assignable)thisObj.field(generatedClassInfo.genericTypeField), type);
                }
                blockCreator.set((Assignable)thisObj.field(generatedClassInfo.annotatedElementField), (Expr)method);
            });
            blockCreator.return_();
        }));
    }

    private static void createGetDeclaringClass(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.method("getDeclaringClass", builder -> {
            builder.public_();
            builder.returning(Class.class);
            builder.body(blockCreator -> blockCreator.return_((Expr)Const.of((ClassDesc)ClassDesc.of(memberInfo.descriptor().getDeclaringClassName()))));
        });
    }

    private static void assertIsGoodMethod(MethodDesc method, boolean returnTypeRequired, boolean readMethodWithParameter) {
        String methodName = method.name();
        if (!readMethodWithParameter && method.parameterCount() != 0) {
            throw new IllegalStateException("The getterMethod (%s) must not have any parameters, but has parameters (%s).".formatted(methodName, Arrays.toString(method.parameterTypes().toArray())));
        }
        if (methodName.startsWith("get")) {
            if (method.returnType().equals(ConstantDescs.CD_void)) {
                throw new IllegalStateException("The getterMethod (%s) must have a non-void return type.".formatted(methodName));
            }
        } else if (methodName.startsWith("is")) {
            if (!method.returnType().equals(ConstantDescs.CD_boolean)) {
                throw new IllegalStateException("The getterMethod (%s) must have a primitive boolean return type but returns (%s).\nMaybe rename the method (get%s)?".formatted(methodName, method.returnType(), methodName.substring(2)));
            }
        } else if (returnTypeRequired && method.returnType().equals(ConstantDescs.CD_void)) {
            throw new IllegalStateException("The readMethod (%s) must have a non-void return type.".formatted(methodName));
        }
    }

    private static void assertIsGoodMethod(MethodDesc method, boolean returnTypeRequired, boolean readMethodWithParameter, Class<? extends Annotation> annotationClass) {
        String methodName = method.name();
        if (!readMethodWithParameter && method.parameterCount() != 0) {
            throw new IllegalStateException("The getterMethod (%s) with a %s annotation must not have any parameters, but has parameters (%s).".formatted(methodName, annotationClass.getSimpleName(), method.parameterTypes().stream().map(ClassDesc::descriptorString).toList()));
        }
        if (methodName.startsWith("get")) {
            if (method.returnType().equals(ConstantDescs.CD_void)) {
                throw new IllegalStateException("The getterMethod (%s) with a %s annotation must have a non-void return type.".formatted(methodName, annotationClass.getSimpleName()));
            }
        } else if (methodName.startsWith("is")) {
            if (!method.returnType().equals(ConstantDescs.CD_boolean)) {
                throw new IllegalStateException("The getterMethod (%s) with a %s annotation must have a primitive boolean return type but returns (%s).\nMaybe rename the method (get%s)?".formatted(methodName, annotationClass.getSimpleName(), method.returnType().descriptorString(), methodName.substring(2)));
            }
        } else if (returnTypeRequired && method.returnType().equals(ConstantDescs.CD_void)) {
            throw new IllegalStateException("The readMethod (%s) with a %s annotation must have a non-void return type.".formatted(methodName, annotationClass.getSimpleName()));
        }
    }

    private static void createGetName(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.method("getName", builder -> {
            builder.public_();
            builder.returning(String.class);
            builder.body(blockCreator -> {
                memberInfo.descriptor().whenIsMethod(method -> {
                    Class<? extends Annotation> annotationClass = memberInfo.annotationClass();
                    if (annotationClass == null) {
                        GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.returnTypeRequired(), memberInfo.readMethodWithParameter());
                    } else {
                        GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.returnTypeRequired(), memberInfo.readMethodWithParameter(), annotationClass);
                    }
                });
                String fieldName = memberInfo.descriptor().getName();
                blockCreator.return_((Expr)Const.of((String)fieldName));
            });
        });
    }

    private static void createGetType(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.method("getType", builder -> {
            builder.public_();
            builder.returning(Class.class);
            builder.body(blockCreator -> {
                Type patt18031$temp = memberInfo.descriptor().getType();
                if (patt18031$temp instanceof Class) {
                    Class clazz = (Class)patt18031$temp;
                    blockCreator.return_((Expr)Const.of((Class)clazz));
                } else {
                    blockCreator.return_((Expr)Const.of((ClassDesc)ClassDesc.of(memberInfo.descriptor().getTypeName())));
                }
            });
        });
    }

    private static void createGetGenericType(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        classCreator.method("getGenericType", builder -> {
            builder.public_();
            builder.returning(Type.class);
            builder.body(blockCreator -> blockCreator.return_((Expr)classCreator.this_().field(generatedClassInfo.genericTypeField)));
        });
    }

    private static void createGetGetterMethodParameterType(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        classCreator.method("getGetterMethodParameterType", builder -> {
            builder.public_();
            builder.returning(Type.class);
            builder.body(blockCreator -> blockCreator.return_((Expr)classCreator.this_().field(generatedClassInfo.readMethodParameterTypeField)));
        });
    }

    private static void createExecuteGetter(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.method("executeGetter", builder -> {
            builder.public_();
            builder.returning(Object.class);
            ParamVar bean = builder.parameter("bean", Object.class);
            builder.body(blockCreator -> {
                LocalVar castedBean = blockCreator.localVar("castedBean", ClassDesc.of(memberInfo.descriptor().getDeclaringClassName()), (Expr)bean);
                if (memberInfo.returnTypeRequired()) {
                    blockCreator.return_(memberInfo.descriptor().readMemberValue((BlockCreator)blockCreator, (Expr)castedBean));
                } else {
                    memberInfo.descriptor().readMemberValue((BlockCreator)blockCreator, (Expr)castedBean);
                    blockCreator.returnNull();
                }
            });
        });
    }

    private static void createExecuteGetterWithParameter(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.method("executeGetter", builder -> {
            builder.public_();
            builder.returning(Object.class);
            ParamVar bean = builder.parameter("bean", Object.class);
            ParamVar value = builder.parameter("value", Object.class);
            memberInfo.descriptor().whenIsMethod(md -> GizmoMemberAccessorImplementor.assertIsGoodMethod(md, memberInfo.returnTypeRequired(), memberInfo.readMethodWithParameter()));
            builder.body(blockCreator -> {
                LocalVar castedBean = blockCreator.localVar("castedBean", ClassDesc.of(memberInfo.descriptor().getDeclaringClassName()), (Expr)bean);
                LocalVar castedValue = blockCreator.localVar("castedValue", ClassDesc.of(memberInfo.descriptor().getMethodParameterType().getTypeName()), (Expr)value);
                if (memberInfo.returnTypeRequired()) {
                    blockCreator.return_(memberInfo.descriptor().readMemberValue((BlockCreator)blockCreator, (Expr)castedBean, (Expr)castedValue));
                } else {
                    memberInfo.descriptor().readMemberValue((BlockCreator)blockCreator, (Expr)castedBean);
                    blockCreator.returnNull();
                }
            });
        });
    }

    private static void createExecuteSetter(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        GizmoMemberInfo memberInfo = generatedClassInfo.memberInfo;
        classCreator.method("executeSetter", builder -> {
            builder.public_();
            builder.returning(Void.TYPE);
            ParamVar bean = builder.parameter("bean", Object.class);
            ParamVar value = builder.parameter("value", Object.class);
            builder.body(blockCreator -> {
                LocalVar castedBean = blockCreator.localVar("castedBean", ClassDesc.of(memberInfo.descriptor().getDeclaringClassName()), (Expr)bean);
                if (memberInfo.descriptor().writeMemberValue((BlockCreator)blockCreator, (Expr)castedBean, (Expr)value)) {
                    blockCreator.return_();
                } else {
                    blockCreator.throw_(blockCreator.new_(UnsupportedOperationException.class, (Expr)Const.of((String)"Setter not supported")));
                }
            });
        });
    }

    private static MethodDesc getAnnotationMethod(Class<?> returnType, String methodName, Class<?> ... parameters) {
        return MethodDesc.of(AnnotatedElement.class, (String)methodName, returnType, (Class[])parameters);
    }

    private static void createGetAnnotation(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        classCreator.method("getAnnotation", builder -> {
            builder.public_();
            builder.returning(Annotation.class);
            ParamVar query = builder.parameter("query", Class.class);
            builder.body(blockCreator -> {
                InstanceFieldVar annotatedElement = classCreator.this_().field(generatedClassInfo.annotatedElementField);
                blockCreator.return_(blockCreator.invokeInterface(GizmoMemberAccessorImplementor.getAnnotationMethod(Annotation.class, "getAnnotation", Class.class), (Expr)annotatedElement, (Expr)query));
            });
        });
    }

    private static void createDeclaredAnnotationsByType(GeneratedClassInfo generatedClassInfo) {
        ClassCreator classCreator = generatedClassInfo.classCreator;
        classCreator.method("getDeclaredAnnotationsByType", builder -> {
            builder.public_();
            builder.returning(Annotation[].class);
            ParamVar query = builder.parameter("query", Class.class);
            builder.body(blockCreator -> {
                InstanceFieldVar annotatedElement = classCreator.this_().field(generatedClassInfo.annotatedElementField);
                blockCreator.return_(blockCreator.invokeInterface(GizmoMemberAccessorImplementor.getAnnotationMethod(Annotation[].class, "getDeclaredAnnotationsByType", Class.class), (Expr)annotatedElement, (Expr)query));
            });
        });
    }

    private GizmoMemberAccessorImplementor() {
    }

    private record GeneratedClassInfo(ClassCreator classCreator, FieldDesc genericTypeField, FieldDesc readMethodParameterTypeField, FieldDesc annotatedElementField, GizmoMemberInfo memberInfo) {
    }
}

