/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberHandler;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.reflect.Type;
import java.util.function.Consumer;

final class GizmoFieldHandler
implements GizmoMemberHandler {
    private final Class<?> declaringClass;
    private final FieldDesc fieldDescriptor;
    private final boolean canBeWritten;

    GizmoFieldHandler(Class<?> declaringClass, FieldDesc fieldDescriptor, boolean canBeWritten) {
        this.declaringClass = declaringClass;
        this.fieldDescriptor = fieldDescriptor;
        this.canBeWritten = canBeWritten;
    }

    @Override
    public void whenIsField(Consumer<FieldDesc> fieldDescriptorConsumer) {
        fieldDescriptorConsumer.accept(this.fieldDescriptor);
    }

    @Override
    public void whenIsMethod(Consumer<MethodDesc> methodDescriptorConsumer) {
    }

    @Override
    public Expr readMemberValue(BlockCreator bytecodeCreator, Expr thisObj) {
        return thisObj.field(this.fieldDescriptor);
    }

    @Override
    public Expr readMemberValue(BlockCreator bytecodeCreator, Expr thisObj, Expr parameter) {
        throw new IllegalStateException("Cannot pass a parameter when reading member value.");
    }

    @Override
    public boolean writeMemberValue(MethodDesc setter, BlockCreator bytecodeCreator, Expr thisObj, Expr newValue) {
        if (this.canBeWritten) {
            bytecodeCreator.set((Assignable)thisObj.field(this.fieldDescriptor), newValue);
            return true;
        }
        return false;
    }

    @Override
    public String getDeclaringClassName() {
        return GizmoMemberHandler.getTypeName(this.fieldDescriptor.owner());
    }

    @Override
    public String getTypeName() {
        return GizmoMemberHandler.getTypeName(this.fieldDescriptor.type());
    }

    @Override
    public Type getType() {
        try {
            return this.declaringClass.getDeclaredField(this.fieldDescriptor.name()).getGenericType();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Cannot find field (%s) on class (%s).".formatted(this.fieldDescriptor.name(), this.declaringClass), e);
        }
    }

    public String toString() {
        return this.fieldDescriptor.toString();
    }
}

