/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.index;

import java.util.AbstractList;
import java.util.List;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ComposingList<E>
extends AbstractList<E> {
    private final NavigableMap<Integer, List<E>> listOfLists = new TreeMap<Integer, List<E>>();
    private int size = 0;

    ComposingList() {
    }

    public void addSubList(List<E> list) {
        int listSize = list.size();
        if (listSize == 0) {
            return;
        }
        this.listOfLists.put(this.size, list);
        this.size += list.size();
    }

    public void addSubList(Supplier<? extends List<E>> listSupplier, int listSize) {
        if (listSize == 0) {
            return;
        }
        this.listOfLists.put(this.size, new OnDemandList(listSupplier));
        this.size += listSize;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: %d, Size: %d".formatted(index, this.size));
        }
        SortedMap<Integer, List<E>> headMap = this.listOfLists.headMap(index + 1);
        Integer subListStartIndex = headMap.lastKey();
        List subList = (List)this.listOfLists.get(subListStartIndex);
        int indexInSubList = index - subListStartIndex;
        return subList.get(indexInSubList);
    }

    @Override
    public int size() {
        return this.size;
    }

    private static final class OnDemandList<E>
    extends AbstractList<E> {
        private final Supplier<? extends List<E>> listSupplier;
        private @Nullable List<E> list;

        public OnDemandList(Supplier<? extends List<E>> listSupplier) {
            this.listSupplier = listSupplier;
        }

        private List<E> getList() {
            if (this.list == null) {
                this.list = this.listSupplier.get();
            }
            return this.list;
        }

        @Override
        public E get(int index) {
            return this.getList().get(index);
        }

        @Override
        public int size() {
            return this.getList().size();
        }
    }
}

