/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.InOutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;

public abstract class AbstractUnindexedJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightEntry;
    private final ElementAwareLinkedList<LeftTuple_> leftTupleList = new ElementAwareLinkedList();
    private final ElementAwareLinkedList<UniTuple<Right_>> rightTupleList = new ElementAwareLinkedList();

    protected AbstractUnindexedJoinNode(TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, InOutTupleStorePositionTracker tupleStorePositionTracker) {
        super(nextNodesTupleLifecycle, isFiltering, tupleStorePositionTracker);
        this.inputStoreIndexLeftEntry = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexRightEntry = tupleStorePositionTracker.reserveNextRight();
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(leftTuple));
        }
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftEntry, this.leftTupleList.add(leftTuple));
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftOutTupleList, new ElementAwareLinkedList());
        if (!((AbstractTuple)leftTuple).state.isActive()) {
            return;
        }
        for (UniTuple<Right_> rightTuple : this.rightTupleList) {
            this.insertOutTupleFiltered(leftTuple, rightTuple);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry) == null) {
            this.insertLeft(leftTuple);
            return;
        }
        this.innerUpdateLeft(leftTuple, this.rightTupleList::forEach);
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        ElementAwareLinkedList.Entry leftEntry = (ElementAwareLinkedList.Entry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftEntry);
        if (leftEntry == null) {
            return;
        }
        ElementAwareLinkedList outTupleListLeft = (ElementAwareLinkedList)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftOutTupleList);
        leftEntry.remove();
        outTupleListLeft.clear(this::retractOutTupleByLeft);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(rightTuple));
        }
        rightTuple.setStore(this.inputStoreIndexRightEntry, this.rightTupleList.add(rightTuple));
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, new ElementAwareLinkedList());
        for (AbstractTuple leftTuple : this.leftTupleList) {
            this.insertOutTupleFilteredFromLeft(leftTuple, rightTuple);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) == null) {
            this.insertRight(rightTuple);
            return;
        }
        this.innerUpdateRight(rightTuple, this.leftTupleList::forEach);
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        ElementAwareLinkedList.Entry rightEntry = (ElementAwareLinkedList.Entry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            return;
        }
        ElementAwareLinkedList outTupleListRight = (ElementAwareLinkedList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        rightEntry.remove();
        outTupleListRight.clear(this::retractOutTupleByRight);
    }
}

