/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.ExistsCounter;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.InTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;

public abstract class AbstractUnindexedIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightEntry;
    private final ElementAwareLinkedList<ExistsCounter<LeftTuple_>> counterList = new ElementAwareLinkedList();
    private final ElementAwareLinkedList<UniTuple<Right_>> rightTupleList = new ElementAwareLinkedList();

    protected AbstractUnindexedIfExistsNode(boolean shouldExist, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering, InTupleStorePositionTracker tupleStorePositionTracker) {
        super(shouldExist, nextNodesTupleLifecycle, isFiltering, tupleStorePositionTracker);
        this.inputStoreIndexLeftCounterEntry = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexRightEntry = tupleStorePositionTracker.reserveNextRight();
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(leftTuple));
        }
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCounterEntry, this.counterList.add(counter));
        if (!this.isFiltering) {
            counter.countRight = this.rightTupleList.size();
        } else {
            ElementAwareLinkedList leftTrackerList = new ElementAwareLinkedList();
            for (UniTuple<Right_> rightTuple : this.rightTupleList) {
                this.updateCounterFromLeft(counter, rightTuple, leftTrackerList);
            }
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
        this.initCounterLeft(counter);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        ElementAwareLinkedList.Entry counterEntry = (ElementAwareLinkedList.Entry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        if (counterEntry == null) {
            this.insertLeft(leftTuple);
            return;
        }
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (!this.isFiltering) {
            this.updateUnchangedCounterLeft(counter);
        } else {
            ElementAwareLinkedList leftTrackerList = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.clear(AbstractIfExistsNode.FilteringTracker::removeByLeft);
            counter.countRight = 0;
            for (UniTuple<Right_> rightTuple : this.rightTupleList) {
                this.updateCounterFromLeft(counter, rightTuple, leftTrackerList);
            }
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        ElementAwareLinkedList.Entry counterEntry = (ElementAwareLinkedList.Entry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftCounterEntry);
        if (counterEntry == null) {
            return;
        }
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        counterEntry.remove();
        if (this.isFiltering) {
            ElementAwareLinkedList leftTrackerList = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.clear(AbstractIfExistsNode.FilteringTracker::removeByLeft);
        }
        this.killCounterLeft(counter);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(rightTuple));
        }
        rightTuple.setStore(this.inputStoreIndexRightEntry, this.rightTupleList.add(rightTuple));
        if (!this.isFiltering) {
            this.counterList.forEach(this::incrementCounterRight);
        } else {
            ElementAwareLinkedList rightTrackerList = new ElementAwareLinkedList();
            for (ExistsCounter<LeftTuple_> counter : this.counterList) {
                this.updateCounterFromRight(counter, rightTuple, rightTrackerList);
            }
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        ElementAwareLinkedList.Entry rightEntry = (ElementAwareLinkedList.Entry)rightTuple.getStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            this.insertRight(rightTuple);
            return;
        }
        if (this.isFiltering) {
            ElementAwareLinkedList rightTrackerList = this.clearRightTrackerList(rightTuple);
            for (ExistsCounter<LeftTuple_> counter : this.counterList) {
                this.updateCounterFromRight(counter, rightTuple, rightTrackerList);
            }
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        ElementAwareLinkedList.Entry rightEntry = (ElementAwareLinkedList.Entry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            return;
        }
        rightEntry.remove();
        if (!this.isFiltering) {
            this.counterList.forEach(this::decrementCounterRight);
        } else {
            this.clearRightTrackerList(rightTuple);
        }
    }
}

