/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.InOutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;
import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.function.Consumer;

public abstract class AbstractIndexedJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft;
    private final IndexerFactory.UniKeysExtractor<Right_> keysExtractorRight;
    private final int inputStoreIndexLeftCompositeKey;
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightCompositeKey;
    private final int inputStoreIndexRightEntry;
    private final Indexer<LeftTuple_> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedJoinNode(IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft, IndexerFactory<Right_> indexerFactory, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, InOutTupleStorePositionTracker tupleStorePositionTracker) {
        super(nextNodesTupleLifecycle, isFiltering, tupleStorePositionTracker);
        this.keysExtractorLeft = keysExtractorLeft;
        this.keysExtractorRight = indexerFactory.buildRightKeysExtractor();
        this.inputStoreIndexLeftCompositeKey = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexLeftEntry = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexRightCompositeKey = tupleStorePositionTracker.reserveNextRight();
        this.inputStoreIndexRightEntry = tupleStorePositionTracker.reserveNextRight();
        this.indexerLeft = indexerFactory.buildIndexer(true);
        this.indexerRight = indexerFactory.buildIndexer(false);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCompositeKey) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(leftTuple));
        }
        Object compositeKey = this.keysExtractorLeft.apply(leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftOutTupleList, new ElementAwareLinkedList());
        this.indexAndPropagateLeft(leftTuple, compositeKey);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        Object oldCompositeKey = ((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCompositeKey);
        if (oldCompositeKey == null) {
            this.insertLeft(leftTuple);
            return;
        }
        Object newCompositeKey = this.keysExtractorLeft.apply(leftTuple);
        if (oldCompositeKey.equals(newCompositeKey)) {
            this.innerUpdateLeft(leftTuple, consumer -> this.indexerRight.forEach(oldCompositeKey, (Consumer<UniTuple<Right_>>)consumer));
        } else {
            ElementAwareLinkedList outTupleListLeft = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
            this.indexerLeft.remove(oldCompositeKey, (ListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry));
            outTupleListLeft.clear(this::retractOutTupleByLeft);
            this.indexAndPropagateLeft(leftTuple, newCompositeKey);
        }
    }

    private void indexAndPropagateLeft(LeftTuple_ leftTuple, Object compositeKey) {
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCompositeKey, compositeKey);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftEntry, this.indexerLeft.put(compositeKey, leftTuple));
        if (!((AbstractTuple)leftTuple).state.isActive()) {
            return;
        }
        this.indexerRight.forEach(compositeKey, rightTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        Object compositeKey = ((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftCompositeKey);
        if (compositeKey == null) {
            return;
        }
        ElementAwareLinkedList outTupleListLeft = (ElementAwareLinkedList)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftOutTupleList);
        this.indexerLeft.remove(compositeKey, (ListEntry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftEntry));
        outTupleListLeft.clear(this::retractOutTupleByLeft);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightCompositeKey) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(rightTuple));
        }
        Object compositeKey = this.keysExtractorRight.apply(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, new ElementAwareLinkedList());
        this.indexAndPropagateRight(rightTuple, compositeKey);
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        Object oldCompositeKey = rightTuple.getStore(this.inputStoreIndexRightCompositeKey);
        if (oldCompositeKey == null) {
            this.insertRight(rightTuple);
            return;
        }
        Object newCompositeKey = this.keysExtractorRight.apply(rightTuple);
        if (oldCompositeKey.equals(newCompositeKey)) {
            this.innerUpdateRight(rightTuple, consumer -> this.indexerLeft.forEach(oldCompositeKey, (Consumer<LeftTuple_>)consumer));
        } else {
            ElementAwareLinkedList outTupleListRight = (ElementAwareLinkedList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
            this.indexerRight.remove(oldCompositeKey, (ListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry));
            outTupleListRight.clear(this::retractOutTupleByRight);
            this.indexAndPropagateRight(rightTuple, newCompositeKey);
        }
    }

    private void indexAndPropagateRight(UniTuple<Right_> rightTuple, Object compositeKey) {
        rightTuple.setStore(this.inputStoreIndexRightCompositeKey, compositeKey);
        rightTuple.setStore(this.inputStoreIndexRightEntry, this.indexerRight.put(compositeKey, rightTuple));
        this.indexerLeft.forEach(compositeKey, leftTuple -> this.insertOutTupleFilteredFromLeft(leftTuple, rightTuple));
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        Object compositeKey = rightTuple.removeStore(this.inputStoreIndexRightCompositeKey);
        if (compositeKey == null) {
            return;
        }
        ElementAwareLinkedList outTupleListRight = (ElementAwareLinkedList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        this.indexerRight.remove(compositeKey, (ListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry));
        outTupleListRight.clear(this::retractOutTupleByRight);
    }
}

