/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.ExistsCounter;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.InTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;
import ai.timefold.solver.core.impl.util.ListEntry;

public abstract class AbstractIndexedIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft;
    private final IndexerFactory.UniKeysExtractor<Right_> keysExtractorRight;
    private final int inputStoreIndexLefCompositeKey;
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightCompositeKey;
    private final int inputStoreIndexRightEntry;
    private final Indexer<ExistsCounter<LeftTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedIfExistsNode(boolean shouldExist, IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft, IndexerFactory<Right_> indexerFactory, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering, InTupleStorePositionTracker tupleStorePositionTracker) {
        super(shouldExist, nextNodesTupleLifecycle, isFiltering, tupleStorePositionTracker);
        this.keysExtractorLeft = keysExtractorLeft;
        this.keysExtractorRight = indexerFactory.buildRightKeysExtractor();
        this.inputStoreIndexLefCompositeKey = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexLeftCounterEntry = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexRightCompositeKey = tupleStorePositionTracker.reserveNextRight();
        this.inputStoreIndexRightEntry = tupleStorePositionTracker.reserveNextRight();
        this.indexerLeft = indexerFactory.buildIndexer(true);
        this.indexerRight = indexerFactory.buildIndexer(false);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLefCompositeKey) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(leftTuple));
        }
        Object compositeKey = this.keysExtractorLeft.apply(leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLefCompositeKey, compositeKey);
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        this.updateCounterRight(leftTuple, compositeKey, counter, this.indexerLeft.put(compositeKey, counter));
        this.initCounterLeft(counter);
    }

    private void updateCounterRight(LeftTuple_ leftTuple, Object compositeKey, ExistsCounter<LeftTuple_> counter, ListEntry<ExistsCounter<LeftTuple_>> counterEntry) {
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
        if (!this.isFiltering) {
            counter.countRight = this.indexerRight.size(compositeKey);
        } else {
            ElementAwareLinkedList leftTrackerList = new ElementAwareLinkedList();
            this.indexerRight.forEach(compositeKey, rightTuple -> this.updateCounterFromLeft(counter, rightTuple, leftTrackerList));
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        Object oldCompositeKey = ((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLefCompositeKey);
        if (oldCompositeKey == null) {
            this.insertLeft(leftTuple);
            return;
        }
        Object newCompositeKey = this.keysExtractorLeft.apply(leftTuple);
        ListEntry counterEntry = (ListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (oldCompositeKey.equals(newCompositeKey)) {
            if (!this.isFiltering) {
                this.updateUnchangedCounterLeft(counter);
            } else {
                ElementAwareLinkedList leftTrackerList = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
                leftTrackerList.clear(AbstractIfExistsNode.FilteringTracker::removeByLeft);
                counter.countRight = 0;
                this.indexerRight.forEach(oldCompositeKey, rightTuple -> this.updateCounterFromLeft(counter, rightTuple, leftTrackerList));
                this.updateCounterLeft(counter);
            }
        } else {
            this.updateIndexerLeft(oldCompositeKey, counterEntry, leftTuple);
            counter.countRight = 0;
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLefCompositeKey, newCompositeKey);
            this.updateCounterRight(leftTuple, newCompositeKey, counter, this.indexerLeft.put(newCompositeKey, counter));
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        Object compositeKey = ((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLefCompositeKey);
        if (compositeKey == null) {
            return;
        }
        ListEntry counterEntry = (ListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        this.updateIndexerLeft(compositeKey, counterEntry, leftTuple);
        this.killCounterLeft((ExistsCounter)counterEntry.getElement());
    }

    private void updateIndexerLeft(Object compositeKey, ListEntry<ExistsCounter<LeftTuple_>> counterEntry, LeftTuple_ leftTuple) {
        this.indexerLeft.remove(compositeKey, counterEntry);
        if (this.isFiltering) {
            ElementAwareLinkedList leftTrackerList = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.clear(AbstractIfExistsNode.FilteringTracker::removeByLeft);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightCompositeKey) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (%s) was already added in the tupleStore.".formatted(rightTuple));
        }
        Object compositeKey = this.keysExtractorRight.apply(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightCompositeKey, compositeKey);
        rightTuple.setStore(this.inputStoreIndexRightEntry, this.indexerRight.put(compositeKey, rightTuple));
        this.updateCounterLeft(rightTuple, compositeKey);
    }

    private void updateCounterLeft(UniTuple<Right_> rightTuple, Object compositeKey) {
        if (!this.isFiltering) {
            this.indexerLeft.forEach(compositeKey, this::incrementCounterRight);
        } else {
            ElementAwareLinkedList rightTrackerList = new ElementAwareLinkedList();
            this.indexerLeft.forEach(compositeKey, counter -> this.updateCounterFromRight(counter, rightTuple, rightTrackerList));
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        Object oldCompositeKey = rightTuple.getStore(this.inputStoreIndexRightCompositeKey);
        if (oldCompositeKey == null) {
            this.insertRight(rightTuple);
            return;
        }
        Object newCompositeKey = this.keysExtractorRight.apply(rightTuple);
        if (oldCompositeKey.equals(newCompositeKey)) {
            if (this.isFiltering) {
                ElementAwareLinkedList rightTrackerList = this.clearRightTrackerList(rightTuple);
                this.indexerLeft.forEach(oldCompositeKey, counter -> this.updateCounterFromRight(counter, rightTuple, rightTrackerList));
            }
        } else {
            this.indexerRight.remove(oldCompositeKey, (ListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry));
            if (!this.isFiltering) {
                this.indexerLeft.forEach(oldCompositeKey, this::decrementCounterRight);
            } else {
                this.clearRightTrackerList(rightTuple);
            }
            rightTuple.setStore(this.inputStoreIndexRightCompositeKey, newCompositeKey);
            rightTuple.setStore(this.inputStoreIndexRightEntry, this.indexerRight.put(newCompositeKey, rightTuple));
            this.updateCounterLeft(rightTuple, newCompositeKey);
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        Object compositeKey = rightTuple.removeStore(this.inputStoreIndexRightCompositeKey);
        if (compositeKey == null) {
            return;
        }
        this.indexerRight.remove(compositeKey, (ListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry));
        if (!this.isFiltering) {
            this.indexerLeft.forEach(compositeKey, this::decrementCounterRight);
        } else {
            this.clearRightTrackerList(rightTuple);
        }
    }
}

