/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractFlattenLastNode<InTuple_ extends AbstractTuple, OutTuple_ extends AbstractTuple, EffectiveItem_, FlattenedItem_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int flattenLastStoreIndex;
    private final Function<EffectiveItem_, Iterable<FlattenedItem_>> mappingFunction;
    private final StaticPropagationQueue<OutTuple_> propagationQueue;

    protected AbstractFlattenLastNode(int flattenLastStoreIndex, Function<EffectiveItem_, Iterable<FlattenedItem_>> mappingFunction, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle) {
        this.flattenLastStoreIndex = flattenLastStoreIndex;
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
        this.propagationQueue = new StaticPropagationQueue<OutTuple_>(nextNodesTupleLifecycle);
    }

    @Override
    public final void insert(InTuple_ tuple) {
        if (((AbstractTuple)tuple).getStore(this.flattenLastStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(tuple) + ") was already added in the tupleStore.");
        }
        Iterable<FlattenedItem_> iterable = this.mappingFunction.apply(this.getEffectiveFactIn(tuple));
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            int size = collection.size();
            if (size == 0) {
                return;
            }
            FlattenBagByItem bagByItem = new FlattenBagByItem(size);
            for (Object item : collection) {
                this.addTuple(tuple, item, bagByItem);
            }
            ((AbstractTuple)tuple).setStore(this.flattenLastStoreIndex, bagByItem);
        } else {
            Iterator<FlattenedItem_> iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            FlattenBagByItem bagByItem = new FlattenBagByItem();
            while (iterator.hasNext()) {
                this.addTuple(tuple, iterator.next(), bagByItem);
            }
            ((AbstractTuple)tuple).setStore(this.flattenLastStoreIndex, bagByItem);
        }
    }

    private void addTuple(InTuple_ originalTuple, FlattenedItem_ item, FlattenBagByItem<FlattenedItem_, OutTuple_> bagByItem) {
        FlattenItemBag<FlattenedItem_, AbstractTuple> outTupleBag = bagByItem.getBag(item);
        outTupleBag.add(() -> this.createTuple(originalTuple, outTupleBag.value), this.propagationQueue::insert, this.propagationQueue::update);
    }

    protected abstract OutTuple_ createTuple(InTuple_ var1, FlattenedItem_ var2);

    @Override
    public final void update(InTuple_ tuple) {
        FlattenBagByItem bagByItem = (FlattenBagByItem)((AbstractTuple)tuple).getStore(this.flattenLastStoreIndex);
        if (bagByItem == null) {
            this.insert(tuple);
            return;
        }
        Iterable<FlattenedItem_> iterable = this.mappingFunction.apply(this.getEffectiveFactIn(tuple));
        for (FlattenItemBag flattenItemBag : bagByItem.getAllBags()) {
            flattenItemBag.reset();
        }
        for (FlattenItemBag flattenItemBag : iterable) {
            this.addTuple(tuple, flattenItemBag, bagByItem);
        }
        Iterator bagIterator = bagByItem.getAllBags().iterator();
        while (bagIterator.hasNext()) {
            FlattenItemBag flattenItemBag = bagIterator.next();
            flattenItemBag.removeExtras(this::removeTuple);
            if (flattenItemBag.newCount.intValue() != 0) continue;
            bagIterator.remove();
        }
    }

    protected abstract EffectiveItem_ getEffectiveFactIn(InTuple_ var1);

    @Override
    public final void retract(InTuple_ tuple) {
        FlattenBagByItem bagByItem = (FlattenBagByItem)((AbstractTuple)tuple).removeStore(this.flattenLastStoreIndex);
        if (bagByItem == null) {
            return;
        }
        for (FlattenItemBag flattenItemBag : bagByItem.getAllBags()) {
            flattenItemBag.reset();
            flattenItemBag.removeExtras(this::removeTuple);
        }
    }

    private void removeTuple(OutTuple_ outTuple) {
        TupleState state = ((AbstractTuple)outTuple).state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (" + String.valueOf(outTuple) + ") is in an unexpected state (" + String.valueOf((Object)((AbstractTuple)outTuple).state) + ").");
        }
        this.propagationQueue.retract(outTuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }

    private record FlattenBagByItem<FlattenedItem_, OutTuple_>(Map<FlattenedItem_, FlattenItemBag<FlattenedItem_, OutTuple_>> delegate) {
        FlattenBagByItem() {
            this(new LinkedHashMap());
        }

        FlattenBagByItem(int size) {
            this(CollectionUtils.newLinkedHashMap(size));
        }

        Collection<FlattenItemBag<FlattenedItem_, OutTuple_>> getAllBags() {
            return this.delegate.values();
        }

        FlattenItemBag<FlattenedItem_, OutTuple_> getBag(FlattenedItem_ key) {
            return this.delegate.computeIfAbsent(key, FlattenItemBag::new);
        }
    }

    private record FlattenItemBag<FlattenedItem_, OutTuple_>(FlattenedItem_ value, MutableInt newCount, List<OutTuple_> outTupleList) {
        FlattenItemBag(FlattenedItem_ value) {
            this(value, new MutableInt(), new ArrayList());
        }

        void add(Supplier<OutTuple_> outTupleSupplier, Consumer<OutTuple_> insertConsumer, Consumer<OutTuple_> updateConsumer) {
            int listIndex = this.newCount.intValue();
            this.newCount.increment();
            if (this.newCount.intValue() > this.outTupleList.size()) {
                OutTuple_ inserted = outTupleSupplier.get();
                this.outTupleList.add(inserted);
                insertConsumer.accept(inserted);
            } else {
                updateConsumer.accept(this.outTupleList.get(listIndex));
            }
        }

        void removeExtras(Consumer<OutTuple_> retractConsumer) {
            for (int i = this.newCount.intValue(); i < this.outTupleList.size(); ++i) {
                retractConsumer.accept(this.outTupleList.get(i));
            }
            this.outTupleList.subList(this.newCount.intValue(), this.outTupleList.size()).clear();
        }

        void reset() {
            this.newCount.setValue(0);
        }
    }
}

