/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.bi.joiner;

import ai.timefold.solver.core.api.score.stream.bi.BiJoiner;
import ai.timefold.solver.core.impl.bavet.bi.joiner.DefaultBiJoiner;
import ai.timefold.solver.core.impl.bavet.bi.joiner.FilteringBiJoiner;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;

public final class BiJoinerComber<A, B> {
    private DefaultBiJoiner<A, B> mergedJoiner;
    private final BiPredicate<A, B> mergedFiltering;

    public static <A, B> BiJoinerComber<A, B> comb(BiJoiner<A, B> ... joiners) {
        ArrayList defaultJoinerList = new ArrayList(joiners.length);
        ArrayList<BiPredicate<A, B>> filteringList = new ArrayList<BiPredicate<A, B>>(joiners.length);
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joiners.length; ++i) {
            BiJoiner<A, B> joiner = joiners[i];
            if (joiner instanceof FilteringBiJoiner) {
                indexOfFirstFilter = i;
                filteringList.add(((FilteringBiJoiner)joiner).getFilter());
                continue;
            }
            if (joiner instanceof DefaultBiJoiner) {
                if (indexOfFirstFilter >= 0) {
                    throw new IllegalStateException("Indexing joiner (" + String.valueOf(joiner) + ") must not follow a filtering joiner (" + String.valueOf(joiners[indexOfFirstFilter]) + ").\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.");
                }
                defaultJoinerList.add((DefaultBiJoiner)joiner);
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + String.valueOf(joiner.getClass()) + ") is not supported.");
        }
        DefaultBiJoiner mergedJoiner = DefaultBiJoiner.merge(defaultJoinerList);
        BiPredicate<A, B> mergedFiltering = BiJoinerComber.mergeFiltering(filteringList);
        return new BiJoinerComber(mergedJoiner, mergedFiltering);
    }

    private static <A, B> BiPredicate<A, B> mergeFiltering(List<BiPredicate<A, B>> filteringList) {
        if (filteringList.isEmpty()) {
            return null;
        }
        switch (filteringList.size()) {
            case 1: {
                return filteringList.get(0);
            }
            case 2: {
                return filteringList.get(0).and(filteringList.get(1));
            }
        }
        return (a, b) -> {
            for (BiPredicate predicate : filteringList) {
                if (predicate.test(a, b)) continue;
                return false;
            }
            return true;
        };
    }

    public BiJoinerComber(DefaultBiJoiner<A, B> mergedJoiner, BiPredicate<A, B> mergedFiltering) {
        this.mergedJoiner = mergedJoiner;
        this.mergedFiltering = mergedFiltering;
    }

    public DefaultBiJoiner<A, B> getMergedJoiner() {
        return this.mergedJoiner;
    }

    public BiPredicate<A, B> getMergedFiltering() {
        return this.mergedFiltering;
    }

    public void addJoiner(DefaultBiJoiner<A, B> extraJoiner) {
        this.mergedJoiner = this.mergedJoiner.and((BiJoiner)extraJoiner);
    }
}

