/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver.event;

import ai.timefold.solver.core.impl.phase.PhaseType;
import ai.timefold.solver.core.impl.phase.event.PhaseEventProducerId;
import ai.timefold.solver.core.impl.solver.event.SolveEventProducerId;
import java.util.OptionalInt;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface EventProducerId {
    public String producerId();

    public String simpleProducerName();

    public OptionalInt phaseIndex();

    public static EventProducerId unknown() {
        return SolveEventProducerId.UNKNOWN;
    }

    public static EventProducerId solvingStarted() {
        return SolveEventProducerId.SOLVING_STARTED;
    }

    public static EventProducerId problemChange() {
        return SolveEventProducerId.PROBLEM_CHANGE;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public static EventProducerId noChange(int phaseIndex) {
        return new PhaseEventProducerId(PhaseType.NO_CHANGE, phaseIndex);
    }

    public static EventProducerId constructionHeuristic(int phaseIndex) {
        return new PhaseEventProducerId(PhaseType.CONSTRUCTION_HEURISTIC, phaseIndex);
    }

    public static EventProducerId localSearch(int phaseIndex) {
        return new PhaseEventProducerId(PhaseType.LOCAL_SEARCH, phaseIndex);
    }

    public static EventProducerId exhaustiveSearch(int phaseIndex) {
        return new PhaseEventProducerId(PhaseType.EXHAUSTIVE_SEARCH, phaseIndex);
    }

    public static EventProducerId partitionedSearch(int phaseIndex) {
        return new PhaseEventProducerId(PhaseType.PARTITIONED_SEARCH, phaseIndex);
    }

    public static EventProducerId customPhase(int phaseIndex) {
        return new PhaseEventProducerId(PhaseType.CUSTOM_PHASE, phaseIndex);
    }
}

