/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import java.time.Duration;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class SolverConfigOverride<Solution_> {
    private TerminationConfig terminationConfig = null;
    private boolean hasSpecificTerminationSettings = false;

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public @NonNull SolverConfigOverride<Solution_> withTerminationConfig(@NonNull TerminationConfig terminationConfig) {
        if (this.hasSpecificTerminationSettings) {
            throw new IllegalStateException("Cannot set terminationConfig after specific termination settings\n(withTerminationSpentLimit or withTerminationUnimprovedSpentLimit) have been applied.\nMaybe call withTerminationConfig() first, or use the TerminationConfig builder methods directly.");
        }
        this.terminationConfig = Objects.requireNonNull(terminationConfig, "Invalid terminationConfig (null) given to SolverConfigOverride.");
        return this;
    }

    public @NonNull SolverConfigOverride<Solution_> withTerminationSpentLimit(@NonNull Duration spentLimit) {
        if (this.terminationConfig == null) {
            this.terminationConfig = new TerminationConfig();
        }
        this.terminationConfig.setSpentLimit(spentLimit);
        this.hasSpecificTerminationSettings = true;
        return this;
    }

    public @NonNull SolverConfigOverride<Solution_> withTerminationUnimprovedSpentLimit(@NonNull Duration unimprovedSpentLimit) {
        if (this.terminationConfig == null) {
            this.terminationConfig = new TerminationConfig();
        }
        this.terminationConfig.setUnimprovedSpentLimit(unimprovedSpentLimit);
        this.hasSpecificTerminationSettings = true;
        return this;
    }
}

