/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ListBasedScalingOrderedSet<E>
implements Set<E> {
    protected static final int LIST_SIZE_THRESHOLD = 16;
    private boolean belowThreshold = true;
    private List<E> list = new ArrayList(16);
    private Set<E> set = null;

    @Override
    public int size() {
        return this.belowThreshold ? this.list.size() : this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.belowThreshold ? this.list.isEmpty() : this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.belowThreshold ? this.list.contains(o) : this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.belowThreshold ? this.list.containsAll(c) : this.set.containsAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> childIterator = this.belowThreshold ? this.list.iterator() : this.set.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return childIterator.hasNext();
            }

            @Override
            public E next() {
                return childIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.belowThreshold ? this.list.toArray() : this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.belowThreshold ? this.list.toArray(a) : this.set.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.belowThreshold) {
            int newSize = this.list.size() + 1;
            if (newSize > 16) {
                this.set = new LinkedHashSet<E>(this.list);
                this.list = null;
                this.belowThreshold = false;
                return this.set.add(e);
            }
            if (this.list.contains(e)) {
                return false;
            }
            return this.list.add(e);
        }
        return this.set.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.belowThreshold) {
            int newSize = this.list.size() + c.size();
            if (newSize > 16) {
                this.set = new LinkedHashSet(newSize);
                this.set.addAll(this.list);
                this.list = null;
                this.belowThreshold = false;
                return this.set.addAll(c);
            }
            boolean changed = false;
            for (E e : c) {
                if (this.list.contains(e)) continue;
                changed = true;
                this.list.add(e);
            }
            return changed;
        }
        return this.set.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.belowThreshold) {
            return this.list.remove(o);
        }
        if (!this.set.remove(o)) {
            return false;
        }
        int newSize = this.set.size();
        if (newSize <= 16) {
            this.list = new ArrayList<E>(this.set);
            this.set = null;
            this.belowThreshold = true;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll() not yet implemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll() not yet implemented");
    }

    @Override
    public void clear() {
        if (this.belowThreshold) {
            this.list.clear();
        } else {
            this.list = new ArrayList(16);
            this.set = null;
            this.belowThreshold = true;
        }
    }

    public String toString() {
        return this.belowThreshold ? this.list.toString() : this.set.toString();
    }
}

