/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.recaller;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.solver.event.EventProducerId;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.event.SolverEventSupport;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;

public class BestSolutionRecaller<Solution_>
extends PhaseLifecycleListenerAdapter<Solution_> {
    protected boolean assertInitialScoreFromScratch = false;
    protected boolean assertShadowVariablesAreNotStale = false;
    protected boolean assertBestScoreIsUnmodified = false;
    protected SolverEventSupport<Solution_> solverEventSupport;

    public void setAssertInitialScoreFromScratch(boolean assertInitialScoreFromScratch) {
        this.assertInitialScoreFromScratch = assertInitialScoreFromScratch;
    }

    public void setAssertShadowVariablesAreNotStale(boolean assertShadowVariablesAreNotStale) {
        this.assertShadowVariablesAreNotStale = assertShadowVariablesAreNotStale;
    }

    public void setAssertBestScoreIsUnmodified(boolean assertBestScoreIsUnmodified) {
        this.assertBestScoreIsUnmodified = assertBestScoreIsUnmodified;
    }

    public void setSolverEventSupport(SolverEventSupport<Solution_> solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        InnerScoreDirector scoreDirector = solverScope.getScoreDirector();
        InnerScore innerScore = scoreDirector.calculateScore();
        Object score = innerScore.raw();
        solverScope.setBestScore(innerScore);
        solverScope.setBestSolutionTimeMillis(solverScope.getClock().millis());
        solverScope.getSolutionDescriptor().setScore(solverScope.getBestSolution(), score);
        if (innerScore.isFullyAssigned()) {
            solverScope.setStartingInitializedScore((Score<?>)innerScore.raw());
        } else {
            solverScope.setStartingInitializedScore(null);
        }
        if (this.assertInitialScoreFromScratch) {
            scoreDirector.assertWorkingScoreFromScratch(innerScore, "Initial score calculated");
        }
        if (this.assertShadowVariablesAreNotStale) {
            scoreDirector.assertShadowVariablesAreNotStale(innerScore, "Initial score calculated");
        }
    }

    public void processWorkingSolutionDuringConstructionHeuristicsStep(AbstractStepScope<Solution_> stepScope) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        SolverScope<Solution_> solverScope = phaseScope.getSolverScope();
        stepScope.setBestScoreImproved(true);
        phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
        Solution_ newBestSolution = stepScope.getWorkingSolution();
        this.updateBestSolutionWithoutFiring(solverScope, stepScope.getScore(), newBestSolution);
    }

    public <Score_ extends Score<Score_>> void processWorkingSolutionDuringStep(AbstractStepScope<Solution_> stepScope) {
        SolverScope<Solution_> solverScope;
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        InnerScore score = stepScope.getScore();
        boolean bestScoreImproved = score.compareTo((solverScope = phaseScope.getSolverScope()).getBestScore()) > 0;
        stepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution_ newBestSolution = stepScope.createOrGetClonedSolution();
            InnerScore innerScore = InnerScore.withUnassignedCount(solverScope.getSolutionDescriptor().getScore(newBestSolution), -stepScope.getScoreDirector().getWorkingInitScore());
            this.updateBestSolutionAndFire(solverScope, phaseScope, innerScore, newBestSolution);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScoreFromScratch(solverScope.getBestSolution());
        }
    }

    public <Score_ extends Score<Score_>> void processWorkingSolutionDuringMove(InnerScore<Score_> moveScore, AbstractStepScope<Solution_> stepScope) {
        boolean bestScoreImproved;
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        SolverScope<Solution_> solverScope = phaseScope.getSolverScope();
        boolean bl = bestScoreImproved = moveScore.compareTo(solverScope.getBestScore()) > 0;
        if (bestScoreImproved) {
            stepScope.setBestScoreImproved(bestScoreImproved);
        }
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution_ newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            InnerScore<Score_> innerScore = new InnerScore<Score_>(moveScore.raw(), solverScope.getScoreDirector().getWorkingInitScore());
            this.updateBestSolutionAndFire(solverScope, phaseScope, innerScore, newBestSolution);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScoreFromScratch(solverScope.getBestSolution());
        }
    }

    public void updateBestSolutionAndFire(SolverScope<Solution_> solverScope, AbstractPhaseScope<Solution_> phaseScope) {
        this.updateBestSolutionWithoutFiring(solverScope);
        this.solverEventSupport.fireBestSolutionChanged(solverScope, phaseScope.getPhaseId(), solverScope.getBestSolution());
    }

    public void updateBestSolutionAndFireIfInitialized(SolverScope<Solution_> solverScope, EventProducerId eventProducerId) {
        this.updateBestSolutionWithoutFiring(solverScope);
        if (solverScope.isBestSolutionInitialized()) {
            this.solverEventSupport.fireBestSolutionChanged(solverScope, eventProducerId, solverScope.getBestSolution());
        }
    }

    private void updateBestSolutionAndFire(SolverScope<Solution_> solverScope, AbstractPhaseScope<Solution_> phaseScope, InnerScore<?> bestScore, Solution_ bestSolution) {
        this.updateBestSolutionWithoutFiring(solverScope, bestScore, bestSolution);
        this.solverEventSupport.fireBestSolutionChanged(solverScope, phaseScope.getPhaseId(), bestSolution);
    }

    private void updateBestSolutionWithoutFiring(SolverScope<Solution_> solverScope) {
        Solution_ newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
        Object newBestScore = solverScope.getSolutionDescriptor().getScore(newBestSolution);
        InnerScore innerScore = InnerScore.withUnassignedCount(newBestScore, -solverScope.getScoreDirector().getWorkingInitScore());
        this.updateBestSolutionWithoutFiring(solverScope, innerScore, newBestSolution);
    }

    private void updateBestSolutionWithoutFiring(SolverScope<Solution_> solverScope, InnerScore<?> bestScore, Solution_ bestSolution) {
        if (bestScore.isFullyAssigned() && !solverScope.isBestSolutionInitialized()) {
            solverScope.setStartingInitializedScore((Score<?>)bestScore.raw());
        }
        solverScope.setBestSolution(bestSolution);
        solverScope.setBestScore(bestScore);
        solverScope.setBestSolutionTimeMillis(solverScope.getClock().millis());
    }
}

