/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.TupleSource;
import ai.timefold.solver.core.impl.bavet.uni.PrecomputeUniNode;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetPrecomputeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetAftBridgeUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetRecordingUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class BavetPrecomputeUniConstraintStream<Solution_, A>
extends BavetAbstractUniConstraintStream<Solution_, A>
implements TupleSource {
    private final BavetAbstractConstraintStream<Solution_> recordingPrecomputedConstraintStream;
    private final Set<Class<?>> entityClassSet;
    private BavetAftBridgeUniConstraintStream<Solution_, A> aftStream;

    public BavetPrecomputeUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractConstraintStream<Solution_> precomputedConstraintStream) {
        super(constraintFactory, RetrievalSemantics.STANDARD);
        this.recordingPrecomputedConstraintStream = new BavetRecordingUniConstraintStream(constraintFactory, precomputedConstraintStream);
        this.entityClassSet = constraintFactory.getSolutionDescriptor().getEntityClassSet();
        precomputedConstraintStream.getChildStreamList().add(this.recordingPrecomputedConstraintStream);
    }

    public void setAftBridge(BavetAftBridgeUniConstraintStream<Solution_, A> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        Supplier precomputeBuildHelperSupplier = () -> new BavetPrecomputeBuildHelper(this.recordingPrecomputedConstraintStream, this.entityClassSet);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        buildHelper.addNode(new PrecomputeUniNode(precomputeBuildHelperSupplier, outputStoreSize, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), precomputeBuildHelperSupplier.get().getSourceClasses()), this);
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        constraintStreamSet.add(this);
    }

    public int hashCode() {
        return Objects.hash(this.recordingPrecomputedConstraintStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetPrecomputeUniConstraintStream) {
            BavetPrecomputeUniConstraintStream other = (BavetPrecomputeUniConstraintStream)o;
            return this.recordingPrecomputedConstraintStream.equals(other.recordingPrecomputedConstraintStream);
        }
        return false;
    }
}

