/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.bi;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.bi.BavetAbstractBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import java.util.Objects;
import java.util.function.BiPredicate;

final class BavetFilterBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B> {
    private final BiPredicate<A, B> predicate;

    public BavetFilterBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BiPredicate<A, B> predicate) {
        super(constraintFactory, parent);
        this.predicate = predicate;
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate (null) cannot be null.");
        }
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        buildHelper.putInsertUpdateRetract(this, this.childStreamList, tupleLifecycle -> TupleLifecycle.conditionally(tupleLifecycle, this.predicate));
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterBiConstraintStream) {
            BavetFilterBiConstraintStream other = (BavetFilterBiConstraintStream)o;
            return this.parent == other.parent && this.predicate == other.predicate;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }
}

