/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.easy;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.easy.EasyScoreDirectorFactory;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class EasyScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, EasyScoreDirectorFactory<Solution_, Score_>> {
    private final EasyScoreCalculator<Solution_, Score_> easyScoreCalculator;

    private EasyScoreDirector(Builder<Solution_, Score_> builder) {
        super(builder);
        this.easyScoreCalculator = Objects.requireNonNull(builder.easyScoreCalculator, "The easyScoreCalculator must not be null.");
    }

    public EasyScoreCalculator<Solution_, Score_> getEasyScoreCalculator() {
        return this.easyScoreCalculator;
    }

    @Override
    public InnerScore<Score_> calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score_ score = this.easyScoreCalculator.calculateScore(this.workingSolution);
        this.setCalculatedScore(score);
        return new InnerScore<Score_>(score, -this.getWorkingInitScore());
    }

    @Override
    public void setWorkingSolutionWithoutUpdatingShadows(Solution_ workingSolution) {
        super.setWorkingSolutionWithoutUpdatingShadows(workingSolution, null);
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        throw new IllegalStateException("%s is not supported by %s.".formatted(ConstraintMatch.class.getSimpleName(), EasyScoreDirector.class.getSimpleName()));
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        throw new IllegalStateException("%s is not supported by %s.".formatted(ConstraintMatch.class.getSimpleName(), EasyScoreDirector.class.getSimpleName()));
    }

    @Override
    public boolean requiresFlushing() {
        return false;
    }

    @NullMarked
    public static final class Builder<Solution_, Score_ extends Score<Score_>>
    extends AbstractScoreDirector.AbstractScoreDirectorBuilder<Solution_, Score_, EasyScoreDirectorFactory<Solution_, Score_>, Builder<Solution_, Score_>> {
        private @Nullable EasyScoreCalculator<Solution_, Score_> easyScoreCalculator;

        public Builder(EasyScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
            super(scoreDirectorFactory);
        }

        @Override
        public Builder<Solution_, Score_> withConstraintMatchPolicy(ConstraintMatchPolicy constraintMatchPolicy) {
            return (Builder)super.withConstraintMatchPolicy(ConstraintMatchPolicy.DISABLED);
        }

        public Builder<Solution_, Score_> withEasyScoreCalculator(EasyScoreCalculator<Solution_, Score_> easyScoreCalculator) {
            this.easyScoreCalculator = easyScoreCalculator;
            return this;
        }

        public EasyScoreDirector<Solution_, Score_> build() {
            return new EasyScoreDirector(this);
        }
    }
}

