/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.ProblemScaleTracker;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.NullAllowingCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.score.director.SolutionInitializationStatistics;
import ai.timefold.solver.core.impl.util.MathUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.impl.util.MutableLong;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ValueRangeManager<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final CountableValueRange<?>[] fromSolution;
    private final ReachableValues[] reachableValues;
    private final Map<Object, CountableValueRange<?>[]> fromEntityMap = new IdentityHashMap<Object, CountableValueRange<?>[]>();
    private @Nullable Solution_ cachedWorkingSolution = null;
    private @Nullable SolutionInitializationStatistics cachedInitializationStatistics = null;
    private @Nullable ProblemSizeStatistics cachedProblemSizeStatistics = null;

    public static <Solution_> ValueRangeManager<Solution_> of(SolutionDescriptor<Solution_> solutionDescriptor, Solution_ solution) {
        ValueRangeManager<Solution_> valueRangeManager = new ValueRangeManager<Solution_>(solutionDescriptor);
        valueRangeManager.reset(solution);
        return valueRangeManager;
    }

    public ValueRangeManager(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.fromSolution = new CountableValueRange[solutionDescriptor.getValueRangeDescriptorCount()];
        this.reachableValues = new ReachableValues[solutionDescriptor.getValueRangeDescriptorCount()];
    }

    public SolutionInitializationStatistics getInitializationStatistics() {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: initialization statistics requested before the working solution is known.");
        }
        return this.getInitializationStatistics(null);
    }

    public SolutionInitializationStatistics getInitializationStatistics(@Nullable Consumer<Object> finisher) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: initialization statistics requested before the working solution is known.");
        }
        if (finisher == null) {
            if (this.cachedInitializationStatistics == null) {
                this.cachedInitializationStatistics = this.computeInitializationStatistics(this.cachedWorkingSolution, null);
            }
        } else {
            this.cachedInitializationStatistics = this.computeInitializationStatistics(this.cachedWorkingSolution, finisher);
        }
        return this.cachedInitializationStatistics;
    }

    public SolutionInitializationStatistics computeInitializationStatistics(Solution_ solution, @Nullable Consumer<Object> finisher) {
        MutableInt uninitializedEntityCount = new MutableInt();
        MutableInt uninitializedVariableCount = new MutableInt();
        MutableInt unassignedValueCount = new MutableInt();
        MutableInt notInAnyListValueCount = new MutableInt();
        MutableInt genuineEntityCount = new MutableInt();
        MutableInt shadowEntityCount = new MutableInt();
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor != null) {
            int countOnSolution = (int)this.countOnSolution(listVariableDescriptor.getValueRangeDescriptor(), solution);
            notInAnyListValueCount.add(countOnSolution);
            if (!listVariableDescriptor.allowsUnassignedValues()) {
                unassignedValueCount.add(countOnSolution);
            }
        }
        this.solutionDescriptor.visitAllEntities(solution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                genuineEntityCount.increment();
                int uninitializedVariableCountForEntity = entityDescriptor.countUninitializedVariables(entity);
                if (uninitializedVariableCountForEntity > 0) {
                    uninitializedEntityCount.increment();
                    uninitializedVariableCount.add(uninitializedVariableCountForEntity);
                }
            } else {
                shadowEntityCount.increment();
            }
            if (finisher != null) {
                finisher.accept(entity);
            }
            if (!entityDescriptor.hasAnyGenuineListVariables()) {
                return;
            }
            EntityDescriptor listVariableEntityDescriptor = listVariableDescriptor.getEntityDescriptor();
            int countOnEntity = listVariableDescriptor.getListSize(entity);
            notInAnyListValueCount.subtract(countOnEntity);
            if (!listVariableDescriptor.allowsUnassignedValues() && listVariableEntityDescriptor.matchesEntity(entity)) {
                unassignedValueCount.subtract(countOnEntity);
            }
        });
        return new SolutionInitializationStatistics(genuineEntityCount.intValue(), shadowEntityCount.intValue(), uninitializedEntityCount.intValue(), uninitializedVariableCount.intValue(), unassignedValueCount.intValue(), notInAnyListValueCount.intValue());
    }

    public ProblemSizeStatistics getProblemSizeStatistics() {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: problem size requested before the working solution is known.");
        }
        if (this.cachedProblemSizeStatistics == null) {
            this.cachedProblemSizeStatistics = new ProblemSizeStatistics(this.solutionDescriptor.getGenuineEntityCount(this.cachedWorkingSolution), this.solutionDescriptor.getGenuineVariableCount(this.cachedWorkingSolution), this.getApproximateValueCount(), this.getProblemScale());
        }
        return this.cachedProblemSizeStatistics;
    }

    long getApproximateValueCount() {
        Set<GenuineVariableDescriptor> genuineVariableDescriptorSet = Collections.newSetFromMap(new IdentityHashMap());
        this.solutionDescriptor.visitAllEntities(this.cachedWorkingSolution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                genuineVariableDescriptorSet.addAll(entityDescriptor.getGenuineVariableDescriptorList());
            }
        });
        MutableLong out = new MutableLong();
        for (GenuineVariableDescriptor variableDescriptor : genuineVariableDescriptorSet) {
            ValueRangeDescriptor valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
            if (valueRangeDescriptor.canExtractValueRangeFromSolution()) {
                out.add(this.countOnSolution(valueRangeDescriptor, this.cachedWorkingSolution));
                continue;
            }
            this.solutionDescriptor.visitEntitiesByEntityClass(this.cachedWorkingSolution, variableDescriptor.getEntityDescriptor().getEntityClass(), entity -> {
                out.add(this.countOnEntity(valueRangeDescriptor, entity));
                return false;
            });
        }
        return out.longValue();
    }

    double getProblemScale() {
        double scale;
        long logBase = Math.max(2L, this.getMaximumValueRangeSize());
        ProblemScaleTracker problemScaleTracker = new ProblemScaleTracker(logBase);
        this.solutionDescriptor.visitAllEntities(this.cachedWorkingSolution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                this.processProblemScale(entityDescriptor, entity, problemScaleTracker);
            }
        });
        long result = problemScaleTracker.getBasicProblemScaleLog();
        if ((long)problemScaleTracker.getListTotalEntityCount() != 0L) {
            int totalListValueCount = problemScaleTracker.getListTotalValueCount();
            int totalListMovableValueCount = totalListValueCount - problemScaleTracker.getListPinnedValueCount();
            int possibleTargetsForListValue = problemScaleTracker.getListMovableEntityCount();
            ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
            if (listVariableDescriptor != null && listVariableDescriptor.allowsUnassignedValues()) {
                ++possibleTargetsForListValue;
            }
            result += MathUtils.getPossibleArrangementsScaledApproximateLog(1000000L, logBase, totalListMovableValueCount, possibleTargetsForListValue);
        }
        if (Double.isNaN(scale = (double)result / 1000000.0 / MathUtils.getLogInBase(logBase, 10.0)) || Double.isInfinite(scale)) {
            return 0.0;
        }
        return scale;
    }

    long getMaximumValueRangeSize() {
        return this.solutionDescriptor.extractAllEntitiesStream(this.cachedWorkingSolution).mapToLong(entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            return entityDescriptor.isGenuine() ? this.getMaximumValueCount(entityDescriptor, entity) : 0L;
        }).max().orElse(0L);
    }

    private long getMaximumValueCount(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        long maximumValueCount = 0L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            if (variableDescriptor.canExtractValueRangeFromSolution()) {
                maximumValueCount = Math.max(maximumValueCount, this.countOnSolution(variableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution));
                continue;
            }
            maximumValueCount = Math.max(maximumValueCount, this.countOnEntity(variableDescriptor.getValueRangeDescriptor(), entity));
        }
        return maximumValueCount;
    }

    private void processProblemScale(EntityDescriptor<Solution_> entityDescriptor, Object entity, ProblemScaleTracker tracker) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            long valueCount;
            long l = valueCount = variableDescriptor.canExtractValueRangeFromSolution() ? this.countOnSolution(variableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution) : this.countOnEntity(variableDescriptor.getValueRangeDescriptor(), entity);
            if (variableDescriptor instanceof BasicVariableDescriptor) {
                BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor;
                if (basicVariableDescriptor.isChained()) {
                    tracker.addListValueCount(1);
                    if (!entityDescriptor.isMovable(this.cachedWorkingSolution, entity)) {
                        tracker.addPinnedListValueCount(1);
                    }
                    CountableValueRange valueRange = variableDescriptor.canExtractValueRangeFromSolution() ? this.getFromSolution(variableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution) : this.getFromEntity(variableDescriptor.getValueRangeDescriptor(), entity);
                    Iterator valueIterator = valueRange.createOriginalIterator();
                    while (valueIterator.hasNext()) {
                        Object value = valueIterator.next();
                        if (!variableDescriptor.isValuePotentialAnchor(value) || tracker.isAnchorVisited(value)) continue;
                        tracker.incrementListEntityCount(true);
                    }
                    continue;
                }
                if (!entityDescriptor.isMovable(this.cachedWorkingSolution, entity)) continue;
                tracker.addBasicProblemScale(valueCount);
                continue;
            }
            if (variableDescriptor instanceof ListVariableDescriptor) {
                ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
                long size = this.countOnSolution(listVariableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution);
                tracker.setListTotalValueCount((int)size);
                if (entityDescriptor.isMovable(this.cachedWorkingSolution, entity)) {
                    tracker.incrementListEntityCount(true);
                    tracker.addPinnedListValueCount(listVariableDescriptor.getFirstUnpinnedIndex(entity));
                    continue;
                }
                tracker.incrementListEntityCount(false);
                tracker.addPinnedListValueCount(listVariableDescriptor.getListSize(entity));
                continue;
            }
            throw new IllegalStateException("Unhandled subclass of %s encountered (%s).".formatted(VariableDescriptor.class.getSimpleName(), variableDescriptor.getClass().getSimpleName()));
        }
    }

    public <T> CountableValueRange<T> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value range (%s) requested before the working solution is known.".formatted(valueRangeDescriptor));
        }
        return this.getFromSolution(valueRangeDescriptor, this.cachedWorkingSolution);
    }

    public <T> CountableValueRange<T> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        NullAllowingCountableValueRange valueRange = this.fromSolution[valueRangeDescriptor.getOrdinal()];
        if (valueRange == null) {
            ValueRange extractedValueRange = valueRangeDescriptor.extractAllValues(Objects.requireNonNull(solution));
            if (!(extractedValueRange instanceof CountableValueRange)) {
                throw new UnsupportedOperationException("Impossible state: value range (%s) on planning solution (%s) is not countable.\nMaybe replace %s with %s.".formatted(valueRangeDescriptor, solution, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
            }
            NullAllowingCountableValueRange countableValueRange = (NullAllowingCountableValueRange)extractedValueRange;
            valueRange = valueRangeDescriptor.acceptsNullInValueRange() ? new NullAllowingCountableValueRange(countableValueRange) : countableValueRange;
            this.fromSolution[valueRangeDescriptor.getOrdinal()] = valueRange;
        }
        return valueRange;
    }

    public <T> CountableValueRange<T> getFromEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Object entity) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value range (%s) on planning entity (%s) requested before the working solution is known.".formatted(valueRangeDescriptor, entity));
        }
        CountableValueRange[] valueRangeList = this.fromEntityMap.computeIfAbsent(entity, e -> new CountableValueRange[this.solutionDescriptor.getValueRangeDescriptorCount()]);
        CountableValueRange valueRange = valueRangeList[valueRangeDescriptor.getOrdinal()];
        if (valueRange == null) {
            ValueRange extractedValueRange = valueRangeDescriptor.extractValuesFromEntity(this.cachedWorkingSolution, Objects.requireNonNull(entity));
            if (!(extractedValueRange instanceof CountableValueRange)) {
                throw new UnsupportedOperationException("Impossible state: value range (%s) on planning entity (%s) is not countable.\nMaybe replace %s with %s.".formatted(valueRangeDescriptor, entity, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
            }
            CountableValueRange countableValueRange = (CountableValueRange)extractedValueRange;
            valueRange = valueRangeDescriptor.acceptsNullInValueRange() ? new NullAllowingCountableValueRange(countableValueRange) : countableValueRange;
            valueRangeList[valueRangeDescriptor.getOrdinal()] = valueRange;
        }
        return valueRange;
    }

    public long countOnSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        return this.getFromSolution(valueRangeDescriptor, solution).getSize();
    }

    public long countOnEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Object entity) {
        return this.getFromEntity(valueRangeDescriptor, entity).getSize();
    }

    public ReachableValues getReachableValues(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        ReachableValues values = this.reachableValues[variableDescriptor.getValueRangeDescriptor().getOrdinal()];
        if (values != null) {
            return values;
        }
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value reachability requested before the working solution is known.");
        }
        EntityDescriptor<Solution_> entityDescriptor = variableDescriptor.getEntityDescriptor();
        List<Object> entityList = entityDescriptor.extractEntities(this.cachedWorkingSolution);
        Map<Object, Integer> entityIndexMap = ValueRangeManager.buildIndexMap(entityList.iterator(), entityList.size(), false);
        CountableValueRange<Object> valueList = this.getFromSolution(variableDescriptor.getValueRangeDescriptor());
        long valueListSize = valueList.getSize();
        if (valueListSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The structure %s cannot be built for the entity %s (%s) because value range has a size (%d) which is higher than Integer.MAX_VALUE.".formatted(ReachableValues.class.getSimpleName(), entityDescriptor.getEntityClass().getSimpleName(), variableDescriptor.getVariableName(), valueListSize));
        }
        Class<?> valueClass = ValueRangeManager.findValueClass(valueList);
        Map<Object, Integer> valueIndexMap = ValueRangeManager.buildIndexMap(valueList.createOriginalIterator(), (int)valueListSize, ConfigUtils.isGenericTypeImmutable(valueClass));
        List<ReachableValues.ReachableItemValue> reachableValueList = ValueRangeManager.initReachableValueList(valueList, entityList.size());
        for (int i = 0; i < entityList.size(); ++i) {
            Object entity = entityList.get(i);
            CountableValueRange valueRange = this.getFromEntity(variableDescriptor.getValueRangeDescriptor(), entity);
            ValueRangeManager.loadEntityValueRange(i, valueIndexMap, valueRange, reachableValueList);
        }
        this.reachableValues[variableDescriptor.getValueRangeDescriptor().getOrdinal()] = values = new ReachableValues(entityIndexMap, entityList, valueIndexMap, reachableValueList, valueClass, variableDescriptor.getValueRangeDescriptor().acceptsNullInValueRange());
        return values;
    }

    private static <T> @Nullable Class<?> findValueClass(CountableValueRange<T> valueRange) {
        Class<?> valueClass = null;
        int idx = 0;
        while ((long)idx < valueRange.getSize()) {
            T value;
            if ((value = valueRange.get(idx++)) == null) continue;
            valueClass = value.getClass();
            break;
        }
        return valueClass;
    }

    private static Map<Object, Integer> buildIndexMap(Iterator<@Nullable Object> allValues, int size, boolean isImmutable) {
        HashMap<Object, Integer> indexMap = isImmutable ? new HashMap(size) : new IdentityHashMap(size);
        int idx = 0;
        while (allValues.hasNext()) {
            Object value = allValues.next();
            if (value == null) continue;
            indexMap.put(value, idx++);
        }
        return indexMap;
    }

    private static List<ReachableValues.ReachableItemValue> initReachableValueList(CountableValueRange<Object> valueRange, int entityListSize) {
        int size = (int)valueRange.getSize();
        ArrayList<ReachableValues.ReachableItemValue> valueList = new ArrayList<ReachableValues.ReachableItemValue>(size);
        for (int i = 0; i < size; ++i) {
            Object value = valueRange.get(i);
            if (value == null) continue;
            valueList.add(new ReachableValues.ReachableItemValue(value, entityListSize, size));
        }
        return valueList;
    }

    private static <T> void loadEntityValueRange(int entityIndex, Map<Object, Integer> valueIndexMap, CountableValueRange<T> valueRange, List<ReachableValues.ReachableItemValue> reachableValueList) {
        int i = 0;
        while ((long)i < valueRange.getSize()) {
            T value = valueRange.get(i);
            if (value != null) {
                Integer valueIndex = valueIndexMap.get(value);
                ReachableValues.ReachableItemValue item = reachableValueList.get(valueIndex);
                item.addEntity(entityIndex);
                int j = i + 1;
                while ((long)j < valueRange.getSize()) {
                    T otherValue = valueRange.get(j);
                    if (otherValue != null) {
                        Integer otherValueIndex = valueIndexMap.get(otherValue);
                        ReachableValues.ReachableItemValue otherValueItem = reachableValueList.get(otherValueIndex);
                        item.addValue(otherValueIndex);
                        otherValueItem.addValue(valueIndex);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void reset(@Nullable Solution_ workingSolution) {
        Arrays.fill(this.fromSolution, null);
        Arrays.fill(this.reachableValues, null);
        this.fromEntityMap.clear();
        if (workingSolution != null) {
            this.cachedWorkingSolution = workingSolution;
            this.cachedInitializationStatistics = null;
            this.cachedProblemSizeStatistics = null;
        }
    }
}

