/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SubListUnassignMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object sourceEntity;
    private final int sourceIndex;
    private final int length;
    private Collection<Object> planningValues;

    public SubListUnassignMove(ListVariableDescriptor<Solution_> variableDescriptor, SubList subList) {
        this(variableDescriptor, subList.entity(), subList.fromIndex(), subList.length());
    }

    private SubListUnassignMove(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, int length) {
        this.variableDescriptor = variableDescriptor;
        this.sourceEntity = sourceEntity;
        this.sourceIndex = sourceIndex;
        this.length = length;
    }

    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    public int getFromIndex() {
        return this.sourceIndex;
    }

    public int getSubListSize() {
        return this.length;
    }

    public int getToIndex() {
        return this.sourceIndex + this.length;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (this.sourceIndex < 0) {
            return false;
        }
        return this.variableDescriptor.getListSize(this.sourceEntity) >= this.getToIndex();
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        Object sourceList = this.variableDescriptor.getValue(this.sourceEntity);
        List subList = sourceList.subList(this.sourceIndex, this.getToIndex());
        this.planningValues = List.copyOf(subList);
        for (Object element : subList) {
            castScoreDirector.beforeListVariableElementUnassigned(this.variableDescriptor, element);
            castScoreDirector.afterListVariableElementUnassigned(this.variableDescriptor, element);
        }
        castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.getToIndex());
        subList.clear();
        castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex);
    }

    @Override
    public SubListUnassignMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubListUnassignMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.sourceEntity), this.sourceIndex, this.length);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<Object> getPlanningEntities() {
        return List.of(this.sourceEntity);
    }

    @Override
    public Collection<Object> getPlanningValues() {
        return this.planningValues;
    }

    public boolean equals(Object o) {
        if (o instanceof SubListUnassignMove) {
            SubListUnassignMove other = (SubListUnassignMove)o;
            return this.sourceIndex == other.sourceIndex && this.length == other.length && this.variableDescriptor.equals(other.variableDescriptor) && this.sourceEntity.equals(other.sourceEntity);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.length);
    }

    public String toString() {
        return String.format("|%d| {%s[%d..%d] -> null}", this.length, this.sourceEntity, this.sourceIndex, this.getToIndex());
    }
}

