/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.impl.constructionheuristic.ConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.phase.PhaseType;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class RuinRecreateConstructionHeuristicPhase<Solution_>
extends DefaultConstructionHeuristicPhase<Solution_>
implements ConstructionHeuristicPhase<Solution_> {
    private final Set<Object> elementsToRuinSet;
    private final Map<Object, List<Object>> missingUpdatedElementsMap;

    RuinRecreateConstructionHeuristicPhase(RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> builder) {
        super(builder);
        this.elementsToRuinSet = Objects.requireNonNullElse(builder.elementsToRuin, Collections.emptySet());
        this.missingUpdatedElementsMap = new IdentityHashMap<Object, List<Object>>();
    }

    @Override
    protected ConstructionHeuristicPhaseScope<Solution_> buildPhaseScope(SolverScope<Solution_> solverScope, int phaseIndex) {
        return new RuinRecreateConstructionHeuristicPhaseScope<Solution_>(solverScope, phaseIndex);
    }

    @Override
    protected boolean isNested() {
        return true;
    }

    @Override
    public PhaseType getPhaseType() {
        return PhaseType.RUIN_AND_RECREATE_CONSTRUCTION_HEURISTIC;
    }

    @Override
    protected void doStep(ConstructionHeuristicStepScope<Solution_> stepScope) {
        if (!this.elementsToRuinSet.isEmpty()) {
            ListVariableDescriptor listVariableDescriptor = stepScope.getPhaseScope().getSolverScope().getSolutionDescriptor().getListVariableDescriptor();
            Object entity = stepScope.getStep().extractPlanningEntities().iterator().next();
            if (!this.elementsToRuinSet.contains(entity)) {
                this.missingUpdatedElementsMap.computeIfAbsent(entity, e -> List.copyOf(listVariableDescriptor.getValue(e)));
            }
        }
        super.doStep(stepScope);
    }

    public Map<Object, List<Object>> getMissingUpdatedElementsMap() {
        return this.missingUpdatedElementsMap;
    }
}

