/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionListIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.ValueRangeManager;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class FilteringEntityByEntitySelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntitySelector<Solution_> {
    private final EntitySelector<Solution_> replayingEntitySelector;
    private final EntitySelector<Solution_> childEntitySelector;
    private final boolean randomSelection;
    private Object replayedEntity;
    private BasicVariableDescriptor<Solution_>[] basicVariableDescriptors;
    private ValueRangeManager<Solution_> valueRangeManager;
    private ReachableValues reachableValues;
    private List<Object> allEntities;

    public FilteringEntityByEntitySelector(EntitySelector<Solution_> childEntitySelector, EntitySelector<Solution_> replayingEntitySelector, boolean randomSelection) {
        this.childEntitySelector = childEntitySelector;
        this.replayingEntitySelector = replayingEntitySelector;
        this.randomSelection = randomSelection;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.childEntitySelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        List<BasicVariableDescriptor> basicVariableList = this.childEntitySelector.getEntityDescriptor().getGenuineBasicVariableDescriptorList().stream().filter(v -> !v.isListVariable() && !v.canExtractValueRangeFromSolution()).map(v -> (BasicVariableDescriptor)v).toList();
        if (basicVariableList.isEmpty()) {
            throw new IllegalStateException("Impossible state: no basic variable found for the entity %s.".formatted(this.childEntitySelector.getEntityDescriptor().getEntityClass()));
        }
        this.allEntities = this.childEntitySelector.getEntityDescriptor().extractEntities(phaseScope.getWorkingSolution());
        this.basicVariableDescriptors = basicVariableList.toArray(new BasicVariableDescriptor[0]);
        this.valueRangeManager = phaseScope.getScoreDirector().getValueRangeManager();
        if (this.basicVariableDescriptors.length == 1) {
            this.reachableValues = this.valueRangeManager.getReachableValues(this.basicVariableDescriptors[0]);
        }
        this.childEntitySelector.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.childEntitySelector.stepStarted(stepScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.childEntitySelector.phaseEnded(phaseScope);
        this.replayedEntity = null;
        this.valueRangeManager = null;
        this.basicVariableDescriptors = null;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public long getSize() {
        return this.allEntities.size();
    }

    @Override
    public boolean isCountable() {
        return this.childEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    private Object selectReplayedEntity() {
        Iterator iterator = this.replayingEntitySelector.iterator();
        if (iterator.hasNext()) {
            this.replayedEntity = iterator.next();
        }
        return this.replayedEntity;
    }

    @Override
    public Iterator<Object> endingIterator() {
        return new OriginalFilteringValueRangeIterator<Solution_>(this::selectReplayedEntity, this.childEntitySelector.endingIterator(), this.basicVariableDescriptors, this.valueRangeManager);
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.randomSelection) {
            if (this.basicVariableDescriptors.length == 1) {
                return new SingleVariableRandomFilteringValueRangeIterator<Solution_>(this::selectReplayedEntity, this.childEntitySelector.iterator(), this.basicVariableDescriptors, this.valueRangeManager, this.reachableValues, this.workingRandom, this.allEntities.size());
            }
            if (!this.childEntitySelector.isNeverEnding()) {
                throw new IllegalArgumentException("Impossible state: childEntitySelector must provide a never-ending approach.");
            }
            return new RandomFilteringValueRangeIterator<Solution_>(this::selectReplayedEntity, this.childEntitySelector.iterator(), this.basicVariableDescriptors, this.valueRangeManager, this.allEntities.size());
        }
        return new OriginalFilteringValueRangeIterator<Solution_>(this::selectReplayedEntity, this.childEntitySelector.iterator(), this.basicVariableDescriptors, this.valueRangeManager);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new OriginalFilteringValueRangeListIterator<Solution_>(this::selectReplayedEntity, this.childEntitySelector.listIterator(), this.basicVariableDescriptors, this.valueRangeManager);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new OriginalFilteringValueRangeListIterator<Solution_>(this::selectReplayedEntity, this.childEntitySelector.listIterator(index), this.basicVariableDescriptors, this.valueRangeManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FilteringEntityByEntitySelector)) return false;
        FilteringEntityByEntitySelector that = (FilteringEntityByEntitySelector)other;
        if (!Objects.equals(this.childEntitySelector, that.childEntitySelector)) return false;
        if (!Objects.equals(this.replayingEntitySelector, that.replayingEntitySelector)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.replayingEntitySelector);
    }

    private static class OriginalFilteringValueRangeIterator<Solution_>
    extends AbstractFilteringValueRangeIterator<Solution_> {
        private final Iterator<Object> entityIterator;
        private Object selected = null;

        private OriginalFilteringValueRangeIterator(Supplier<Object> upcomingEntitySupplier, Iterator<Object> entityIterator, BasicVariableDescriptor<Solution_>[] basicVariableDescriptors, ValueRangeManager<Solution_> valueRangeManager) {
            super(upcomingEntitySupplier, basicVariableDescriptors, valueRangeManager);
            this.entityIterator = entityIterator;
        }

        @Override
        void load(Object replayedEntity) {
            this.selected = null;
        }

        @Override
        public boolean hasNext() {
            this.selected = this.pickNext();
            return this.selected != null;
        }

        private Object pickNext() {
            if (this.selected != null) {
                throw new IllegalStateException("The next value has already been picked.");
            }
            this.initialize();
            this.selected = null;
            while (this.entityIterator.hasNext()) {
                Object entity = this.entityIterator.next();
                if (!this.isReachable(entity)) continue;
                return entity;
            }
            return null;
        }

        private Object pickSelected() {
            if (this.selected == null) {
                throw new NoSuchElementException();
            }
            Object result = this.selected;
            this.selected = null;
            return result;
        }

        @Override
        public Object next() {
            return this.pickSelected();
        }
    }

    private static class SingleVariableRandomFilteringValueRangeIterator<Solution_>
    extends AbstractFilteringValueRangeIterator<Solution_> {
        private final Iterator<Object> allEntitiesIterator;
        private final BasicVariableDescriptor<Solution_> basicVariableDescriptor;
        private final ReachableValues reachableValues;
        private final Random workingRandom;
        private final int maxBailoutSize;
        private Object currentReplayedEntity = null;
        private Iterator<Object> entityIterator;
        private int iterationBailoutSize;
        private boolean oneSideValidation;

        private SingleVariableRandomFilteringValueRangeIterator(Supplier<Object> upcomingEntitySupplier, Iterator<Object> allEntitiesIterator, BasicVariableDescriptor<Solution_>[] basicVariableDescriptors, ValueRangeManager<Solution_> valueRangeManager, ReachableValues reachableValues, Random workingRandom, int maxBailoutSize) {
            super(upcomingEntitySupplier, basicVariableDescriptors, valueRangeManager);
            this.allEntitiesIterator = allEntitiesIterator;
            if (basicVariableDescriptors.length > 1) {
                throw new IllegalArgumentException("Impossible state: there are multiple basic variables.");
            }
            this.basicVariableDescriptor = basicVariableDescriptors[0];
            this.reachableValues = reachableValues;
            this.workingRandom = workingRandom;
            this.maxBailoutSize = maxBailoutSize;
            this.entityIterator = allEntitiesIterator;
            this.oneSideValidation = false;
        }

        @Override
        void load(Object replayedEntity) {
            this.currentReplayedEntity = replayedEntity;
            Object value = this.basicVariableDescriptor.getValue(replayedEntity);
            if (value != null) {
                this.oneSideValidation = true;
                List<Object> entityList = this.reachableValues.extractEntitiesAsList(value);
                this.entityIterator = new RandomListIterator(entityList, this.workingRandom);
                this.iterationBailoutSize = entityList.size();
            } else {
                this.oneSideValidation = false;
                this.entityIterator = this.allEntitiesIterator;
                this.iterationBailoutSize = this.maxBailoutSize;
            }
        }

        @Override
        public boolean hasNext() {
            this.checkReplayedEntity();
            return this.entityIterator.hasNext();
        }

        @Override
        public Object next() {
            if (!this.entityIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            int bailoutSize = this.iterationBailoutSize;
            do {
                --bailoutSize;
                Object next = this.entityIterator.next();
                if (!this.isReachable(this.currentReplayedEntity, next, this.oneSideValidation)) continue;
                return next;
            } while (bailoutSize > 0);
            return this.currentReplayedEntity;
        }

        private boolean isReachable(Object replayedEntity, Object otherEntity, boolean oneSideValidation) {
            if (oneSideValidation) {
                Object otherValue = this.basicVariableDescriptor.getValue(otherEntity);
                if (otherValue != null) {
                    return this.reachableValues.isEntityReachable(otherValue, replayedEntity);
                }
                return this.reachableValues.acceptsNullValue();
            }
            return this.isReachable(replayedEntity, otherEntity);
        }
    }

    private static class RandomFilteringValueRangeIterator<Solution_>
    extends AbstractFilteringValueRangeIterator<Solution_> {
        private final Iterator<Object> entityIterator;
        private final int maxBailoutSize;
        private Object currentReplayedEntity = null;

        private RandomFilteringValueRangeIterator(Supplier<Object> upcomingEntitySupplier, Iterator<Object> entityIterator, BasicVariableDescriptor<Solution_>[] basicVariableDescriptors, ValueRangeManager<Solution_> valueRangeManager, int maxBailoutSize) {
            super(upcomingEntitySupplier, basicVariableDescriptors, valueRangeManager);
            this.entityIterator = entityIterator;
            this.maxBailoutSize = maxBailoutSize;
        }

        @Override
        void load(Object replayedEntity) {
            this.currentReplayedEntity = replayedEntity;
        }

        @Override
        public boolean hasNext() {
            this.checkReplayedEntity();
            return this.entityIterator.hasNext();
        }

        @Override
        public Object next() {
            if (!this.entityIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            int bailoutSize = this.maxBailoutSize;
            do {
                --bailoutSize;
                Object next = this.entityIterator.next();
                if (!this.isReachable(this.currentReplayedEntity, next)) continue;
                return next;
            } while (bailoutSize > 0);
            return this.currentReplayedEntity;
        }
    }

    private static class OriginalFilteringValueRangeListIterator<Solution_>
    extends UpcomingSelectionListIterator<Object> {
        private final Supplier<Object> upcomingEntitySupplier;
        private final BasicVariableDescriptor<Solution_>[] basicVariableDescriptors;
        private final ListIterator<Object> entityIterator;
        private final ValueRangeManager<Solution_> valueRangeManager;
        private Object replayedEntity;

        private OriginalFilteringValueRangeListIterator(Supplier<Object> upcomingEntitySupplier, ListIterator<Object> entityIterator, BasicVariableDescriptor<Solution_>[] basicVariableDescriptors, ValueRangeManager<Solution_> valueRangeManager) {
            this.upcomingEntitySupplier = upcomingEntitySupplier;
            this.entityIterator = entityIterator;
            this.basicVariableDescriptors = basicVariableDescriptors;
            this.valueRangeManager = valueRangeManager;
        }

        void checkReplayedEntity() {
            Object newReplayedEntity = this.upcomingEntitySupplier.get();
            if (newReplayedEntity != this.replayedEntity) {
                this.replayedEntity = newReplayedEntity;
            }
        }

        @Override
        public boolean hasNext() {
            this.checkReplayedEntity();
            return super.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            this.checkReplayedEntity();
            return super.hasPrevious();
        }

        @Override
        protected Object createUpcomingSelection() {
            if (!this.entityIterator.hasNext()) {
                return this.noUpcomingSelection();
            }
            while (this.entityIterator.hasNext()) {
                Object otherEntity = this.entityIterator.next();
                if (!this.isReachable(this.replayedEntity, otherEntity)) continue;
                return otherEntity;
            }
            return this.noUpcomingSelection();
        }

        @Override
        protected Object createPreviousSelection() {
            if (!this.entityIterator.hasPrevious()) {
                return this.noUpcomingSelection();
            }
            while (this.entityIterator.hasPrevious()) {
                Object otherEntity = this.entityIterator.previous();
                if (!this.isReachable(this.replayedEntity, otherEntity)) continue;
                return otherEntity;
            }
            return this.noUpcomingSelection();
        }

        boolean isReachable(Object entity, Object otherEntity) {
            if (entity == otherEntity) {
                return false;
            }
            for (BasicVariableDescriptor<Solution_> basicVariableDescriptor : this.basicVariableDescriptors) {
                if (this.isReachable(entity, basicVariableDescriptor.getValue(entity), otherEntity, basicVariableDescriptor.getValue(otherEntity), basicVariableDescriptor, this.valueRangeManager)) continue;
                return false;
            }
            return true;
        }

        private boolean isReachable(Object entity, Object value, Object otherEntity, Object otherValue, BasicVariableDescriptor<Solution_> variableDescriptor, ValueRangeManager<Solution_> valueRangeManager) {
            return valueRangeManager.getFromEntity(variableDescriptor.getValueRangeDescriptor(), entity).contains(otherValue) && valueRangeManager.getFromEntity(variableDescriptor.getValueRangeDescriptor(), otherEntity).contains(value);
        }
    }

    private static class RandomListIterator
    implements Iterator<Object> {
        private final List<Object> values;
        private final Random workingRandom;

        private RandomListIterator(List<Object> values, Random workingRandom) {
            this.values = values;
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return !this.values.isEmpty();
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.values.get(this.workingRandom.nextInt(this.values.size()));
        }
    }

    private static abstract class AbstractFilteringValueRangeIterator<Solution_>
    implements Iterator<Object> {
        private final Supplier<Object> upcomingEntitySupplier;
        private final BasicVariableDescriptor<Solution_>[] basicVariableDescriptors;
        private final ValueRangeManager<Solution_> valueRangeManager;
        private boolean initialized = false;
        private Object replayedEntity;

        private AbstractFilteringValueRangeIterator(Supplier<Object> upcomingEntitySupplier, BasicVariableDescriptor<Solution_>[] basicVariableDescriptors, ValueRangeManager<Solution_> valueRangeManager) {
            this.upcomingEntitySupplier = upcomingEntitySupplier;
            this.basicVariableDescriptors = basicVariableDescriptors;
            this.valueRangeManager = valueRangeManager;
        }

        void initialize() {
            if (this.initialized) {
                return;
            }
            this.checkReplayedEntity();
            this.initialized = true;
        }

        void checkReplayedEntity() {
            Object newReplayedEntity = this.upcomingEntitySupplier.get();
            if (newReplayedEntity != this.replayedEntity) {
                this.replayedEntity = newReplayedEntity;
                this.load(this.replayedEntity);
            }
        }

        abstract void load(Object var1);

        boolean isReachable(Object otherEntity) {
            return this.isReachable(this.replayedEntity, otherEntity);
        }

        boolean isReachable(Object entity, Object otherEntity) {
            if (entity == otherEntity) {
                return false;
            }
            for (BasicVariableDescriptor<Solution_> basicVariableDescriptor : this.basicVariableDescriptors) {
                if (this.isReachable(entity, basicVariableDescriptor.getValue(entity), otherEntity, basicVariableDescriptor.getValue(otherEntity), basicVariableDescriptor, this.valueRangeManager)) continue;
                return false;
            }
            return true;
        }

        private boolean isReachable(Object entity, Object value, Object otherEntity, Object otherValue, BasicVariableDescriptor<Solution_> variableDescriptor, ValueRangeManager<Solution_> valueRangeManager) {
            return valueRangeManager.getFromEntity(variableDescriptor.getValueRangeDescriptor(), entity).contains(otherValue) && valueRangeManager.getFromEntity(variableDescriptor.getValueRangeDescriptor(), otherEntity).contains(value);
        }
    }
}

