/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common;

import java.util.AbstractList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ReachableValues {
    private final Map<Object, Integer> entitiesIndex;
    private final List<Object> allEntities;
    private final Map<Object, Integer> valuesIndex;
    private final List<ReachableItemValue> allValues;
    private final @Nullable Class<?> valueClass;
    private final boolean acceptsNullValue;
    private @Nullable ReachableItemValue firstCachedObject;
    private @Nullable ReachableItemValue secondCachedObject;

    public ReachableValues(Map<Object, Integer> entityIndexMap, List<Object> entityList, Map<Object, Integer> valueIndexMap, List<ReachableItemValue> reachableValueList, @Nullable Class<?> valueClass, boolean acceptsNullValue) {
        this.entitiesIndex = entityIndexMap;
        this.allEntities = entityList;
        this.valuesIndex = valueIndexMap;
        this.allValues = reachableValueList;
        this.valueClass = valueClass;
        this.acceptsNullValue = acceptsNullValue;
    }

    private @Nullable ReachableItemValue fetchItemValue(Object value) {
        ReachableItemValue selected = null;
        if (this.firstCachedObject != null && this.firstCachedObject.value == value) {
            selected = this.firstCachedObject;
        } else if (this.secondCachedObject != null && this.secondCachedObject.value == value) {
            selected = this.secondCachedObject;
            this.secondCachedObject = this.firstCachedObject;
            this.firstCachedObject = selected;
        }
        if (selected == null) {
            Integer index = this.valuesIndex.get(value);
            if (index == null) {
                return null;
            }
            selected = this.allValues.get(index);
            this.secondCachedObject = this.firstCachedObject;
            this.firstCachedObject = selected;
        }
        return selected;
    }

    public List<Object> extractEntitiesAsList(Object value) {
        ReachableItemValue itemValue = this.fetchItemValue(value);
        if (itemValue == null) {
            return Collections.emptyList();
        }
        return itemValue.getRandomAccessEntityList(this.allEntities);
    }

    public List<Object> extractValuesAsList(Object value) {
        ReachableItemValue itemValue = this.fetchItemValue(value);
        if (itemValue == null) {
            return Collections.emptyList();
        }
        return itemValue.getRandomAccessValueList(this.allValues);
    }

    public int getSize() {
        return this.allValues.size();
    }

    public boolean isEntityReachable(@Nullable Object origin, @Nullable Object entity) {
        if (entity == null) {
            return true;
        }
        if (origin == null) {
            return this.acceptsNullValue;
        }
        ReachableItemValue originItemValue = this.fetchItemValue(origin);
        if (originItemValue == null) {
            return false;
        }
        Integer entityIndex = this.entitiesIndex.get(entity);
        if (entityIndex == null) {
            throw new IllegalStateException("The entity %s is not indexed.".formatted(entity));
        }
        return originItemValue.containsEntity(entityIndex);
    }

    public boolean isValueReachable(Object origin, @Nullable Object otherValue) {
        ReachableItemValue originItemValue = this.fetchItemValue(Objects.requireNonNull(origin));
        if (originItemValue == null) {
            return false;
        }
        if (otherValue == null) {
            return this.acceptsNullValue;
        }
        Integer otherValueIndex = this.valuesIndex.get(Objects.requireNonNull(otherValue));
        if (otherValueIndex == null) {
            return false;
        }
        return originItemValue.containsValue(otherValueIndex);
    }

    public boolean acceptsNullValue() {
        return this.acceptsNullValue;
    }

    public boolean matchesValueClass(Object value) {
        return this.valueClass != null && this.valueClass.isAssignableFrom(Objects.requireNonNull(value).getClass());
    }

    @NullMarked
    public static final class ReachableItemValue {
        private final Object value;
        private final BitSet entityBitSet;
        private final BitSet valueBitSet;
        private @Nullable List<Object> onDemandRandomAccessEntityList;
        private @Nullable List<Object> onDemandRandomAccessValueList;

        public ReachableItemValue(Object value, int entityListSize, int valueListSize) {
            this.value = value;
            this.entityBitSet = new BitSet(entityListSize);
            this.valueBitSet = new BitSet(valueListSize);
        }

        public void addEntity(int entityIndex) {
            this.entityBitSet.set(entityIndex);
        }

        public void addValue(int valueIndex) {
            this.valueBitSet.set(valueIndex);
        }

        boolean containsEntity(int entityIndex) {
            return this.entityBitSet.get(entityIndex);
        }

        boolean containsValue(int valueIndex) {
            return this.valueBitSet.get(valueIndex);
        }

        private static int[] extractAllIndexes(BitSet bitSet) {
            int[] indexes = new int[bitSet.cardinality()];
            int idx = 0;
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                indexes[idx++] = i;
                i = bitSet.nextSetBit(i + 1);
            }
            return indexes;
        }

        List<Object> getRandomAccessEntityList(List<Object> allEntities) {
            if (this.onDemandRandomAccessEntityList == null) {
                this.onDemandRandomAccessEntityList = new ArrayIndexedList<Object, Object>(ReachableItemValue.extractAllIndexes(this.entityBitSet), allEntities, null);
            }
            return this.onDemandRandomAccessEntityList;
        }

        List<Object> getRandomAccessValueList(List<ReachableItemValue> allValues) {
            if (this.onDemandRandomAccessValueList == null) {
                this.onDemandRandomAccessValueList = new ArrayIndexedList<ReachableItemValue, Object>(ReachableItemValue.extractAllIndexes(this.valueBitSet), allValues, v -> v.value);
            }
            return this.onDemandRandomAccessValueList;
        }
    }

    @NullMarked
    private static final class ArrayIndexedList<T, V>
    extends AbstractList<V> {
        private final int[] valueIndex;
        private final List<T> allValues;
        private final @Nullable Function<T, V> valueExtractor;

        private ArrayIndexedList(int[] valueIndex, List<T> allValues, @Nullable Function<T, V> valueExtractor) {
            this.valueIndex = valueIndex;
            this.allValues = allValues;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public V get(int index) {
            if (index < 0 || index >= this.valueIndex.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            T value = this.allValues.get(this.valueIndex[index]);
            if (this.valueExtractor == null) {
                return (V)value;
            }
            return this.valueExtractor.apply(value);
        }

        @Override
        public int size() {
            return this.valueIndex.length;
        }
    }
}

