/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support;

import ai.timefold.solver.core.impl.domain.variable.ChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.InnerBasicVariableListener;
import ai.timefold.solver.core.impl.domain.variable.InnerListVariableListener;
import ai.timefold.solver.core.impl.domain.variable.InnerVariableListener;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.ListBasedScalingOrderedSet;
import java.util.ArrayDeque;
import java.util.Collection;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract class AbstractNotifiable<Solution_, ChangeEvent_ extends ChangeEvent, Listener_ extends InnerVariableListener<Solution_, ChangeEvent_>>
implements EntityNotifiable<Solution_> {
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final Listener_ variableListener;
    private final Collection<Notification<Solution_, ChangeEvent_, Listener_>> notificationQueue;
    private final int globalOrder;

    static <Solution_, ChangeEvent_ extends ChangeEvent, Listener_ extends InnerVariableListener<Solution_, ChangeEvent_>> EntityNotifiable<Solution_> buildNotifiable(InnerScoreDirector<Solution_, ?> scoreDirector, Listener_ variableListener, int globalOrder) {
        if (variableListener instanceof InnerBasicVariableListener) {
            InnerBasicVariableListener basicVariableListener = (InnerBasicVariableListener)variableListener;
            return new VariableListenerNotifiable<Solution_>(scoreDirector, basicVariableListener, variableListener.requiresUniqueEntityEvents() ? new ListBasedScalingOrderedSet() : new ArrayDeque(), globalOrder);
        }
        if (variableListener instanceof InnerListVariableListener) {
            InnerListVariableListener listVariableListener = (InnerListVariableListener)variableListener;
            return new ListVariableListenerNotifiable<Solution_, InnerListVariableListener>(scoreDirector, listVariableListener, new ArrayDeque(), globalOrder);
        }
        throw new IllegalArgumentException("Impossible state: InnerVariableListener (%s) must be an instance of %s or %s.".formatted(variableListener.getClass().getCanonicalName(), InnerBasicVariableListener.class.getSimpleName(), InnerListVariableListener.class.getSimpleName()));
    }

    AbstractNotifiable(InnerScoreDirector<Solution_, ?> scoreDirector, Listener_ variableListener, Collection<Notification<Solution_, ChangeEvent_, Listener_>> notificationQueue, int globalOrder) {
        this.scoreDirector = scoreDirector;
        this.variableListener = variableListener;
        this.notificationQueue = notificationQueue;
        this.globalOrder = globalOrder;
    }

    @Override
    public InnerVariableListener<Solution_, ?> getVariableListener() {
        return this.variableListener;
    }

    protected boolean storeForLater(Notification<Solution_, ChangeEvent_, Listener_> notification) {
        return this.notificationQueue.add(notification);
    }

    protected void triggerBefore(Notification<Solution_, ChangeEvent_, Listener_> notification) {
        notification.triggerBefore(this.variableListener, this.scoreDirector);
    }

    @Override
    public void resetWorkingSolution() {
        this.variableListener.resetWorkingSolution(this.scoreDirector);
    }

    @Override
    public void closeVariableListener() {
        this.variableListener.close();
    }

    @Override
    public void clearAllNotifications() {
        this.notificationQueue.clear();
    }

    @Override
    public void triggerAllNotifications() {
        int notifiedCount = 0;
        for (Notification<Solution_, ChangeEvent_, Listener_> notification : this.notificationQueue) {
            notification.triggerAfter(this.variableListener, this.scoreDirector);
            ++notifiedCount;
        }
        if (notifiedCount != this.notificationQueue.size()) {
            throw new IllegalStateException("The variableListener (%s) has been notified with notifiedCount (%d) but after being triggered, its notificationCount (%d) is different.\nMaybe that variableListener (%s) changed an upstream shadow variable (which is illegal).".formatted(this.variableListener.getClass(), notifiedCount, this.notificationQueue.size(), this.variableListener.getClass()));
        }
        this.notificationQueue.clear();
    }

    public String toString() {
        return "(%d) %s".formatted(this.globalOrder, this.variableListener);
    }
}

