/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner.gizmo;

import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GizmoCloningUtils {
    public static Set<Class<?>> getDeepClonedClasses(SolutionDescriptor<?> solutionDescriptor, Collection<Class<?>> entitySubclasses) {
        HashSet deepClonedClassSet = new HashSet();
        LinkedHashSet classesToProcess = new LinkedHashSet(solutionDescriptor.getEntityClassSet());
        classesToProcess.add(solutionDescriptor.getSolutionClass());
        classesToProcess.addAll(entitySubclasses);
        while (!classesToProcess.isEmpty()) {
            Class clazz = (Class)classesToProcess.iterator().next();
            classesToProcess.remove(clazz);
            deepClonedClassSet.add(clazz);
            for (Field field : GizmoCloningUtils.getAllFields(clazz)) {
                Set<Class<?>> deepClonedTypeArguments = GizmoCloningUtils.getDeepClonedTypeArguments(solutionDescriptor, field.getGenericType());
                for (Class<?> deepClonedTypeArgument : deepClonedTypeArguments) {
                    if (deepClonedClassSet.contains(deepClonedTypeArgument)) continue;
                    classesToProcess.add(deepClonedTypeArgument);
                    deepClonedClassSet.add(deepClonedTypeArgument);
                }
                if (!DeepCloningUtils.isFieldDeepCloned(solutionDescriptor, field, clazz) || PlanningCloneable.class.isAssignableFrom(field.getType()) || deepClonedClassSet.contains(field.getType())) continue;
                classesToProcess.add(field.getType());
                deepClonedClassSet.add(field.getType());
            }
        }
        return deepClonedClassSet;
    }

    private static Set<Class<?>> getDeepClonedTypeArguments(SolutionDescriptor<?> solutionDescriptor, Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return Collections.emptySet();
        }
        HashSet deepClonedTypeArguments = new HashSet();
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
            Class class1;
            if (actualTypeArgument instanceof Class && DeepCloningUtils.isClassDeepCloned(solutionDescriptor, class1 = (Class)actualTypeArgument)) {
                deepClonedTypeArguments.add(class1);
            }
            deepClonedTypeArguments.addAll(GizmoCloningUtils.getDeepClonedTypeArguments(solutionDescriptor, actualTypeArgument));
        }
        return deepClonedTypeArguments;
    }

    private static List<Field> getAllFields(Class<?> baseClass) {
        Stream<Object> memberStream = Stream.empty();
        for (Class<?> clazz = baseClass; clazz != null; clazz = clazz.getSuperclass()) {
            Stream<Field> fieldStream = Stream.of(clazz.getDeclaredFields());
            memberStream = Stream.concat(memberStream, fieldStream);
        }
        return memberStream.collect(Collectors.toList());
    }

    private GizmoCloningUtils() {
    }
}

