/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.placer;

import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedValuePlacerConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.constructionheuristic.placer.AbstractEntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.QueuedValuePlacer;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.Objects;

public class QueuedValuePlacerFactory<Solution_>
extends AbstractEntityPlacerFactory<Solution_, QueuedValuePlacerConfig> {
    public static QueuedValuePlacerConfig unfoldNew(MoveSelectorConfig templateMoveSelectorConfig) {
        throw new UnsupportedOperationException("The <constructionHeuristic> contains a moveSelector (%s) and the <queuedValuePlacer> does not support unfolding those yet.".formatted(templateMoveSelectorConfig));
    }

    public QueuedValuePlacerFactory(QueuedValuePlacerConfig placerConfig) {
        super(placerConfig);
    }

    @Override
    public QueuedValuePlacer<Solution_> buildEntityPlacer(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntityDescriptor<Solution_> entityDescriptor = this.deduceEntityDescriptor(configPolicy, ((QueuedValuePlacerConfig)this.config).getEntityClass());
        ValueSelectorConfig valueSelectorConfig_ = this.buildValueSelectorConfig(configPolicy, entityDescriptor);
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig_).buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.PHASE, SelectionOrder.ORIGINAL, false, ValueSelectorFactory.ListValueFilteringType.ACCEPT_UNASSIGNED);
        MoveSelectorConfig moveSelectorConfig_ = ((QueuedValuePlacerConfig)this.config).getMoveSelectorConfig() == null ? this.buildChangeMoveSelectorConfig(configPolicy, valueSelectorConfig_.getId(), valueSelector.getVariableDescriptor()) : ((QueuedValuePlacerConfig)this.config).getMoveSelectorConfig();
        MoveSelector moveSelector = MoveSelectorFactory.create(moveSelectorConfig_).buildMoveSelector(configPolicy, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL, false);
        if (!(valueSelector instanceof IterableValueSelector)) {
            throw new IllegalArgumentException("The queuedValuePlacer (%s) needs to be based on an %s (%s). Check your @%s annotations.".formatted(this, IterableValueSelector.class.getSimpleName(), valueSelector, ValueRangeProvider.class.getSimpleName()));
        }
        IterableValueSelector iterableValueSelector = (IterableValueSelector)valueSelector;
        return new QueuedValuePlacer<Solution_>(this, configPolicy, iterableValueSelector, moveSelector);
    }

    private ValueSelectorConfig buildValueSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        ValueSelectorConfig result = Objects.requireNonNullElseGet(((QueuedValuePlacerConfig)this.config).getValueSelectorConfig(), () -> {
            Class<?> entityClass = entityDescriptor.getEntityClass();
            GenuineVariableDescriptor variableDescriptor = this.getTheOnlyVariableDescriptor(entityDescriptor);
            ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig().withId(entityClass.getName() + "." + variableDescriptor.getVariableName()).withVariableName(variableDescriptor.getVariableName());
            if (ValueSelectorConfig.hasSorter(configPolicy.getValueSorterManner(), variableDescriptor)) {
                valueSelectorConfig = valueSelectorConfig.withCacheType(SelectionCacheType.PHASE).withSelectionOrder(SelectionOrder.SORTED).withSorterManner(configPolicy.getValueSorterManner());
            }
            return valueSelectorConfig;
        });
        SelectionCacheType cacheType = result.getCacheType();
        if (cacheType != null && cacheType.compareTo(SelectionCacheType.PHASE) < 0) {
            throw new IllegalArgumentException("The queuedValuePlacer (%s) cannot have a valueSelectorConfig (%s) with a cacheType (%s) lower than %s.".formatted(new Object[]{this, result, cacheType, SelectionCacheType.PHASE}));
        }
        return result;
    }

    @Override
    protected ChangeMoveSelectorConfig buildChangeMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy, String valueSelectorConfigId, GenuineVariableDescriptor<Solution_> variableDescriptor) {
        ChangeMoveSelectorConfig changeMoveSelectorConfig = new ChangeMoveSelectorConfig();
        EntityDescriptor entityDescriptor = variableDescriptor.getEntityDescriptor();
        EntitySelectorConfig changeEntitySelectorConfig = new EntitySelectorConfig().withEntityClass(entityDescriptor.getEntityClass());
        if (configPolicy.getEntitySorterManner() != null && EntitySelectorConfig.hasSorter(configPolicy.getEntitySorterManner(), entityDescriptor)) {
            changeEntitySelectorConfig = changeEntitySelectorConfig.withCacheType(SelectionCacheType.PHASE).withSelectionOrder(SelectionOrder.SORTED).withSorterManner(configPolicy.getEntitySorterManner());
        }
        ValueSelectorConfig changeValueSelectorConfig = new ValueSelectorConfig().withVariableName(variableDescriptor.getVariableName()).withMimicSelectorRef(valueSelectorConfigId);
        return changeMoveSelectorConfig.withEntitySelectorConfig(changeEntitySelectorConfig).withValueSelectorConfig(changeValueSelectorConfig);
    }
}

