/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.tuple;

import ai.timefold.solver.core.api.function.QuadPredicate;
import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.AggregatedTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.BiTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.ConditionalTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycleImpl;
import ai.timefold.solver.core.impl.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.RecordingTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycleImpl;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public interface TupleLifecycle<Tuple_ extends AbstractTuple> {
    public static <Tuple_ extends AbstractTuple> TupleLifecycle<Tuple_> ofLeft(LeftTupleLifecycle<Tuple_> leftTupleLifecycle) {
        return new LeftTupleLifecycleImpl<Tuple_>(leftTupleLifecycle);
    }

    public static <Tuple_ extends AbstractTuple> TupleLifecycle<Tuple_> ofRight(RightTupleLifecycle<Tuple_> rightTupleLifecycle) {
        return new RightTupleLifecycleImpl<Tuple_>(rightTupleLifecycle);
    }

    @SafeVarargs
    public static <Tuple_ extends AbstractTuple> TupleLifecycle<Tuple_> aggregate(TupleLifecycle<Tuple_> ... tupleLifecycles) {
        TupleLifecycle[] distinctTupleLifecycles = (TupleLifecycle[])Arrays.stream(Objects.requireNonNull(tupleLifecycles)).distinct().toArray(TupleLifecycle[]::new);
        return switch (distinctTupleLifecycles.length) {
            case 0 -> throw new IllegalStateException("Impossible state: there are no tuple lifecycles.");
            case 1 -> distinctTupleLifecycles[0];
            default -> new AggregatedTupleLifecycle(distinctTupleLifecycles);
        };
    }

    public static <A> TupleLifecycle<UniTuple<A>> conditionally(TupleLifecycle<UniTuple<A>> tupleLifecycle, Predicate<A> predicate) {
        return new ConditionalTupleLifecycle<UniTuple<A>>(tupleLifecycle, tuple -> predicate.test(tuple.factA));
    }

    public static <A, B> TupleLifecycle<BiTuple<A, B>> conditionally(TupleLifecycle<BiTuple<A, B>> tupleLifecycle, BiPredicate<A, B> predicate) {
        return new ConditionalTupleLifecycle<BiTuple<A, B>>(tupleLifecycle, tuple -> predicate.test(tuple.factA, tuple.factB));
    }

    public static <A, B, C> TupleLifecycle<TriTuple<A, B, C>> conditionally(TupleLifecycle<TriTuple<A, B, C>> tupleLifecycle, TriPredicate<A, B, C> predicate) {
        return new ConditionalTupleLifecycle<TriTuple<A, B, C>>(tupleLifecycle, tuple -> predicate.test(tuple.factA, tuple.factB, tuple.factC));
    }

    public static <A, B, C, D> TupleLifecycle<QuadTuple<A, B, C, D>> conditionally(TupleLifecycle<QuadTuple<A, B, C, D>> tupleLifecycle, QuadPredicate<A, B, C, D> predicate) {
        return new ConditionalTupleLifecycle<QuadTuple<A, B, C, D>>(tupleLifecycle, tuple -> predicate.test(tuple.factA, tuple.factB, tuple.factC, tuple.factD));
    }

    public static <Tuple_ extends AbstractTuple> TupleLifecycle<Tuple_> recording() {
        return new RecordingTupleLifecycle();
    }

    public void insert(Tuple_ var1);

    public void update(Tuple_ var1);

    public void retract(Tuple_ var1);
}

