/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.BavetRootNode;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.RecordAndReplayPropagator;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetPrecomputeBuildHelper;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class AbstractPrecomputeNode<Tuple_ extends AbstractTuple>
extends AbstractNode
implements BavetRootNode<Object> {
    private final RecordAndReplayPropagator<Tuple_> recordAndReplayPropagator;
    private final Class<?>[] sourceClasses;

    protected AbstractPrecomputeNode(Supplier<BavetPrecomputeBuildHelper<Tuple_>> precomputeBuildHelperSupplier, TupleLifecycle<Tuple_> nextNodesTupleLifecycle, Class<?>[] sourceClasses) {
        this.recordAndReplayPropagator = new RecordAndReplayPropagator<Tuple_>(precomputeBuildHelperSupplier, this::remapTuple, nextNodesTupleLifecycle);
        this.sourceClasses = sourceClasses;
    }

    @Override
    public final Propagator getPropagator() {
        return this.recordAndReplayPropagator;
    }

    @Override
    public final boolean allowsInstancesOf(Class<?> clazz) {
        for (Class<?> sourceClass : this.sourceClasses) {
            if (!sourceClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Class<?>[] getSourceClasses() {
        return this.sourceClasses;
    }

    @Override
    public final boolean supports(BavetRootNode.LifecycleOperation lifecycleOperation) {
        return true;
    }

    @Override
    public final void insert(@Nullable Object a) {
        if (a == null) {
            return;
        }
        this.recordAndReplayPropagator.insert(a);
    }

    @Override
    public final void update(@Nullable Object a) {
        if (a == null) {
            return;
        }
        this.recordAndReplayPropagator.update(a);
    }

    @Override
    public final void retract(@Nullable Object a) {
        if (a == null) {
            return;
        }
        this.recordAndReplayPropagator.retract(a);
    }

    protected abstract Tuple_ remapTuple(Tuple_ var1);
}

