/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.change;

import ai.timefold.solver.core.api.solver.change.ProblemChangeDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DefaultProblemChangeDirector<Solution_>
implements ProblemChangeDirector {
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private boolean problemEntitiesChanged = false;

    public DefaultProblemChangeDirector(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.scoreDirector = scoreDirector;
    }

    @Override
    public <Entity> void addEntity(@NonNull Entity entity, @NonNull Consumer<Entity> entityConsumer) {
        Objects.requireNonNull(entity, () -> "Entity (" + String.valueOf(entity) + ") cannot be null.");
        Objects.requireNonNull(entityConsumer, () -> "Entity consumer (" + String.valueOf(entityConsumer) + ") cannot be null.");
        this.scoreDirector.beforeEntityAdded(entity);
        entityConsumer.accept(entity);
        this.scoreDirector.afterEntityAdded(entity);
        this.problemEntitiesChanged = true;
    }

    @Override
    public <Entity> void removeEntity(@NonNull Entity entity, @NonNull Consumer<Entity> entityConsumer) {
        Objects.requireNonNull(entity, () -> "Entity (" + String.valueOf(entity) + ") cannot be null.");
        Objects.requireNonNull(entityConsumer, () -> "Entity consumer (" + String.valueOf(entityConsumer) + ") cannot be null.");
        Entity workingEntity = this.lookUpWorkingObjectOrFail(entity);
        this.scoreDirector.beforeEntityRemoved(workingEntity);
        entityConsumer.accept(workingEntity);
        this.scoreDirector.afterEntityRemoved(workingEntity);
        this.problemEntitiesChanged = true;
    }

    @Override
    public <Entity> void changeVariable(@NonNull Entity entity, @NonNull String variableName, @NonNull Consumer<Entity> entityConsumer) {
        Objects.requireNonNull(entity, () -> "Entity (" + String.valueOf(entity) + ") cannot be null.");
        Objects.requireNonNull(variableName, () -> "Planning variable name (" + variableName + ") cannot be null.");
        Objects.requireNonNull(entityConsumer, () -> "Entity consumer (" + String.valueOf(entityConsumer) + ") cannot be null.");
        Entity workingEntity = this.lookUpWorkingObjectOrFail(entity);
        this.scoreDirector.beforeVariableChanged(workingEntity, variableName);
        entityConsumer.accept(workingEntity);
        this.scoreDirector.afterVariableChanged(workingEntity, variableName);
    }

    @Override
    public <ProblemFact> void addProblemFact(@NonNull ProblemFact problemFact, @NonNull Consumer<ProblemFact> problemFactConsumer) {
        Objects.requireNonNull(problemFact, () -> "Problem fact (" + String.valueOf(problemFact) + ") cannot be null.");
        Objects.requireNonNull(problemFactConsumer, () -> "Problem fact consumer (" + String.valueOf(problemFactConsumer) + ") cannot be null.");
        this.scoreDirector.beforeProblemFactAdded(problemFact);
        problemFactConsumer.accept(problemFact);
        this.scoreDirector.afterProblemFactAdded(problemFact);
    }

    @Override
    public <ProblemFact> void removeProblemFact(@NonNull ProblemFact problemFact, @NonNull Consumer<ProblemFact> problemFactConsumer) {
        Objects.requireNonNull(problemFact, () -> "Problem fact (" + String.valueOf(problemFact) + ") cannot be null.");
        Objects.requireNonNull(problemFactConsumer, () -> "Problem fact consumer (" + String.valueOf(problemFactConsumer) + ") cannot be null.");
        ProblemFact workingProblemFact = this.lookUpWorkingObjectOrFail(problemFact);
        this.scoreDirector.beforeProblemFactRemoved(workingProblemFact);
        problemFactConsumer.accept(workingProblemFact);
        this.scoreDirector.afterProblemFactRemoved(workingProblemFact);
    }

    @Override
    public <EntityOrProblemFact> void changeProblemProperty(@NonNull EntityOrProblemFact problemFactOrEntity, @NonNull Consumer<EntityOrProblemFact> problemFactOrEntityConsumer) {
        Objects.requireNonNull(problemFactOrEntity, () -> "Problem fact or entity (" + String.valueOf(problemFactOrEntity) + ") cannot be null.");
        Objects.requireNonNull(problemFactOrEntityConsumer, () -> "Problem fact or entity consumer (" + String.valueOf(problemFactOrEntityConsumer) + ") cannot be null.");
        EntityOrProblemFact workingEntityOrProblemFact = this.lookUpWorkingObjectOrFail(problemFactOrEntity);
        this.scoreDirector.beforeProblemPropertyChanged(workingEntityOrProblemFact);
        problemFactOrEntityConsumer.accept(workingEntityOrProblemFact);
        this.scoreDirector.afterProblemPropertyChanged(workingEntityOrProblemFact);
    }

    @Override
    public <EntityOrProblemFact> @Nullable EntityOrProblemFact lookUpWorkingObjectOrFail(@Nullable EntityOrProblemFact externalObject) {
        return this.scoreDirector.lookUpWorkingObject(externalObject);
    }

    @Override
    public <EntityOrProblemFact> Optional<EntityOrProblemFact> lookUpWorkingObject(EntityOrProblemFact externalObject) {
        return Optional.ofNullable(this.scoreDirector.lookUpWorkingObjectOrReturnNull(externalObject));
    }

    @Override
    public void updateShadowVariables() {
        if (this.problemEntitiesChanged) {
            this.scoreDirector.setWorkingSolution(this.scoreDirector.getWorkingSolution());
            this.problemEntitiesChanged = false;
        } else {
            this.scoreDirector.triggerVariableListeners();
        }
    }
}

