/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.heuristic.move.LegacyMoveAdapter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.ChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListUnassignMove;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.RecommendationConstructor;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.move.Move;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class AssignmentProcessor<Solution_, Score_ extends Score<Score_>, Recommendation_, In_, Out_>
implements Function<InnerScoreDirector<Solution_, Score_>, List<Recommendation_>> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final Function<In_, @Nullable Out_> propositionFunction;
    private final RecommendationConstructor<Score_, Recommendation_, Out_> recommendationConstructor;
    private final ScoreAnalysisFetchPolicy fetchPolicy;
    private final ScoreAnalysis<Score_> originalScoreAnalysis;
    private final In_ clonedElement;

    public AssignmentProcessor(DefaultSolverFactory<Solution_> solverFactory, Function<In_, @Nullable Out_> propositionFunction, RecommendationConstructor<Score_, Recommendation_, Out_> recommendationConstructor, ScoreAnalysisFetchPolicy fetchPolicy, In_ clonedElement, ScoreAnalysis<Score_> originalScoreAnalysis) {
        this.solverFactory = Objects.requireNonNull(solverFactory);
        this.propositionFunction = Objects.requireNonNull(propositionFunction);
        this.recommendationConstructor = Objects.requireNonNull(recommendationConstructor);
        this.fetchPolicy = Objects.requireNonNull(fetchPolicy);
        this.originalScoreAnalysis = Objects.requireNonNull(originalScoreAnalysis);
        this.clonedElement = clonedElement;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public List<Recommendation_> apply(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        moveDirector = scoreDirector.getMoveDirector();
        supplyManager = scoreDirector.getSupplyManager();
        solutionDescriptor = this.solverFactory.getSolutionDescriptor();
        listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor != null) {
            demand = listVariableDescriptor.getStateDemand();
            listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(demand);
            try {
                elementPosition = listVariableStateSupply.getElementPosition(this.clonedElement);
                if (!(elementPosition instanceof PositionInList)) ** GOTO lbl33
                positionInList = (PositionInList)elementPosition;
                entity = positionInList.entity();
                index = positionInList.index();
                this.wrapAndExecute(moveDirector, new ListUnassignMove<Solution_>(listVariableDescriptor, entity, index));
            }
            finally {
                if (listVariableStateSupply != null) {
                    listVariableStateSupply.close();
                }
            }
        } else {
            entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(this.clonedElement.getClass());
            for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor;
                if (basicVariableDescriptor.getValue(this.clonedElement) == null) continue;
                if (basicVariableDescriptor.isChained()) {
                    demand = new SingletonInverseVariableDemand<Solution_>(basicVariableDescriptor);
                    supply = supplyManager.demand(demand);
                    this.wrapAndExecute(moveDirector, new ChainedChangeMove<Solution_>(basicVariableDescriptor, this.clonedElement, null, supply));
                    supplyManager.cancel(demand);
                    continue;
                }
                this.wrapAndExecute(moveDirector, new ChangeMove<Solution_>(basicVariableDescriptor, this.clonedElement, null));
            }
        }
lbl33:
        // 3 sources

        scoreDirector.triggerVariableListeners();
        entityPlacer = this.buildEntityPlacer().rebuildWithFilter((SelectionFilter<Solution_, Object>)LambdaMetafactory.metafactory(null, null, null, (Lai/timefold/solver/core/api/score/director/ScoreDirector;Ljava/lang/Object;)Z, lambda$apply$0(ai.timefold.solver.core.api.score.director.ScoreDirector java.lang.Object ), (Lai/timefold/solver/core/api/score/director/ScoreDirector;Ljava/lang/Object;)Z)((AssignmentProcessor)this));
        solverScope = new SolverScope<Solution_>(this.solverFactory.getClock());
        solverScope.setWorkingRandom(new Random(0L));
        solverScope.setScoreDirector(scoreDirector);
        phaseScope = new ConstructionHeuristicPhaseScope<Solution_>(solverScope, -1);
        stepScope = new ConstructionHeuristicStepScope<Solution_>(phaseScope);
        entityPlacer.solvingStarted(solverScope);
        entityPlacer.phaseStarted(phaseScope);
        entityPlacer.stepStarted(stepScope);
        try {
            var10_12 = scoreDirector;
            try {
                placementIterator = entityPlacer.iterator();
                if (!placementIterator.hasNext()) {
                    throw new IllegalStateException("Impossible state: entity placer (%s) has no placements.\n".formatted(new Object[]{entityPlacer}));
                }
                placement = (Placement)placementIterator.next();
                recommendedAssignmentList = new ArrayList<Object>();
                moveIndex = 0L;
                for (Move<Solution_> move : placement) {
                    recommendedAssignmentList.add(this.execute(scoreDirector, move, moveIndex, this.clonedElement, this.propositionFunction));
                    ++moveIndex;
                }
                recommendedAssignmentList.sort(null);
                var16_21 = recommendedAssignmentList;
                if (var10_12 != null) {
                    var10_12.close();
                }
                return var16_21;
            }
            catch (Throwable var11_16) {
                if (var10_12 != null) {
                    try {
                        var10_12.close();
                    }
                    catch (Throwable var12_18) {
                        var11_16.addSuppressed(var12_18);
                    }
                }
                throw var11_16;
            }
        }
        finally {
            entityPlacer.stepEnded(stepScope);
            entityPlacer.phaseEnded(phaseScope);
            entityPlacer.solvingEnded(solverScope);
        }
    }

    private void wrapAndExecute(MoveDirector<Solution_, Score_> moveDirector, ai.timefold.solver.core.impl.heuristic.move.Move<Solution_> move) {
        new LegacyMoveAdapter<Solution_>(move).execute(moveDirector);
    }

    private EntityPlacer<Solution_> buildEntityPlacer() {
        DefaultSolver solver = (DefaultSolver)this.solverFactory.buildSolver();
        List phaseList = solver.getPhaseList();
        long constructionHeuristicCount = phaseList.stream().filter(DefaultConstructionHeuristicPhase.class::isInstance).count();
        if (constructionHeuristicCount != 1L) {
            throw new IllegalStateException("Assignment Recommendation API requires the solver config to have exactly one construction heuristic phase, but it has (%s) instead.".formatted(constructionHeuristicCount));
        }
        Phase phase = phaseList.get(0);
        if (phase instanceof DefaultConstructionHeuristicPhase) {
            DefaultConstructionHeuristicPhase constructionHeuristicPhase = (DefaultConstructionHeuristicPhase)phase;
            return constructionHeuristicPhase.getEntityPlacer();
        }
        throw new IllegalStateException("Assignment Recommendation API requires the first solver phase (%s) in the solver config to be a construction heuristic.".formatted(phase));
    }

    private Recommendation_ execute(InnerScoreDirector<Solution_, Score_> scoreDirector, Move<Solution_> move, long moveIndex, In_ clonedElement, Function<In_, @Nullable Out_> propositionFunction) {
        return (Recommendation_)scoreDirector.getMoveDirector().executeTemporary(move, (moveDirector, score) -> {
            ScoreAnalysis<Score_> newScoreAnalysis = scoreDirector.buildScoreAnalysis(this.fetchPolicy);
            ScoreAnalysis newScoreDifference = newScoreAnalysis.diff(this.originalScoreAnalysis);
            return this.recommendationConstructor.apply(moveIndex, propositionFunction.apply(clonedElement), newScoreDifference);
        });
    }

    private /* synthetic */ boolean lambda$apply$0(ScoreDirector solution, Object selection) {
        return selection == this.clonedElement;
    }
}

