/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ConstraintAnalysis;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.move.director.MoveDirector;
import ai.timefold.solver.core.impl.neighborhood.MoveRepository;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.ValueRangeManager;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public interface InnerScoreDirector<Solution_, Score_ extends Score<Score_>>
extends VariableDescriptorAwareScoreDirector<Solution_>,
AutoCloseable {
    public static <Score_ extends Score<Score_>> ConstraintAnalysis<Score_> getConstraintAnalysis(ConstraintMatchTotal<Score_> constraintMatchTotal, ScoreAnalysisFetchPolicy scoreAnalysisFetchPolicy) {
        return switch (scoreAnalysisFetchPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case ScoreAnalysisFetchPolicy.FETCH_ALL -> {
                Map<ConstraintJustification, List<ConstraintMatch<Score_>>> deduplicatedConstraintMatchMap = constraintMatchTotal.getConstraintMatchSet().stream().collect(Collectors.groupingBy(c -> c.getJustification(), Collectors.toList()));
                List<MatchAnalysis<Score_>> matchAnalyses = InnerScoreDirector.sumMatchesWithSameJustification(constraintMatchTotal, deduplicatedConstraintMatchMap);
                yield new ConstraintAnalysis<Score_>(constraintMatchTotal.getConstraintRef(), constraintMatchTotal.getConstraintWeight(), constraintMatchTotal.getScore(), matchAnalyses);
            }
            case ScoreAnalysisFetchPolicy.FETCH_MATCH_COUNT -> new ConstraintAnalysis<Score_>(constraintMatchTotal.getConstraintRef(), constraintMatchTotal.getConstraintWeight(), constraintMatchTotal.getScore(), null, constraintMatchTotal.getConstraintMatchCount());
            case ScoreAnalysisFetchPolicy.FETCH_SHALLOW -> new ConstraintAnalysis<Score_>(constraintMatchTotal.getConstraintRef(), constraintMatchTotal.getConstraintWeight(), constraintMatchTotal.getScore(), null);
        };
    }

    private static <Score_ extends Score<Score_>> List<MatchAnalysis<Score_>> sumMatchesWithSameJustification(ConstraintMatchTotal<Score_> constraintMatchTotal, Map<ConstraintJustification, List<ConstraintMatch<Score_>>> deduplicatedConstraintMatchMap) {
        return deduplicatedConstraintMatchMap.entrySet().stream().map(entry -> {
            Score score = ((List)entry.getValue()).stream().map(ConstraintMatch::getScore).reduce((Score)constraintMatchTotal.getScore().zero(), Score::add);
            return new MatchAnalysis<Score>(constraintMatchTotal.getConstraintRef(), score, (ConstraintJustification)entry.getKey());
        }).toList();
    }

    public void setWorkingSolution(Solution_ var1);

    public void setWorkingSolutionWithoutUpdatingShadows(Solution_ var1);

    public void setMoveRepository(@Nullable MoveRepository<Solution_> var1);

    public InnerScore<Score_> calculateScore();

    public ConstraintMatchPolicy getConstraintMatchPolicy();

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap();

    public Map<Object, Indictment<Score_>> getIndictmentMap();

    public long getWorkingEntityListRevision();

    public int getWorkingGenuineEntityCount();

    public int getWorkingInitScore();

    public void executeMove(Move<Solution_> var1);

    public InnerScore<Score_> executeTemporaryMove(Move<Solution_> var1, boolean var2);

    public boolean isWorkingEntityListDirty(long var1);

    public boolean isWorkingSolutionInitialized();

    public boolean requiresFlushing();

    public boolean expectShadowVariablesInCorrectState();

    public ScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory();

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor();

    public ScoreDefinition<Score_> getScoreDefinition();

    default public Solution_ cloneWorkingSolution() {
        return this.cloneSolution(this.getWorkingSolution());
    }

    public Solution_ cloneSolution(Solution_ var1);

    public long getCalculationCount();

    public void resetCalculationCount();

    public void incrementCalculationCount();

    public SupplyManager getSupplyManager();

    public MoveDirector<Solution_, Score_> getMoveDirector();

    @Override
    public ValueRangeManager<Solution_> getValueRangeManager();

    public ListVariableStateSupply<Solution_, Object, Object> getListVariableStateSupply(ListVariableDescriptor<Solution_> var1);

    public InnerScoreDirector<Solution_, Score_> createChildThreadScoreDirector(ChildThreadType var1);

    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean var1);

    public void assertExpectedWorkingScore(InnerScore<Score_> var1, Object var2);

    public void assertShadowVariablesAreNotStale(InnerScore<Score_> var1, Object var2);

    public void assertWorkingScoreFromScratch(InnerScore<Score_> var1, Object var2);

    public void assertPredictedScoreFromScratch(InnerScore<Score_> var1, Object var2);

    public void assertExpectedUndoMoveScore(Move<Solution_> var1, InnerScore<Score_> var2, SolverLifecyclePoint var3);

    @Override
    public void close();

    public void forceTriggerVariableListeners();

    default public boolean isDerived() {
        return false;
    }

    default public ScoreAnalysis<Score_> buildScoreAnalysis(ScoreAnalysisFetchPolicy scoreAnalysisFetchPolicy) {
        InnerScore<Score_> state = this.calculateScore();
        TreeMap constraintAnalysisMap = new TreeMap();
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : this.getConstraintMatchTotalMap().values()) {
            ConstraintAnalysis<Score_> constraintAnalysis = InnerScoreDirector.getConstraintAnalysis(constraintMatchTotal, scoreAnalysisFetchPolicy);
            constraintAnalysisMap.put(constraintMatchTotal.getConstraintRef(), constraintAnalysis);
        }
        return new ScoreAnalysis<Score_>(state.raw(), constraintAnalysisMap, state.isFullyAssigned());
    }

    @Override
    default public void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    default public void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    default public void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    default public void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> var1, Object var2);

    @Override
    public void beforeProblemFactAdded(Object var1);

    @Override
    public void afterProblemFactAdded(Object var1);

    @Override
    public void beforeProblemPropertyChanged(Object var1);

    @Override
    public void afterProblemPropertyChanged(Object var1);

    @Override
    public void beforeProblemFactRemoved(Object var1);

    @Override
    public void afterProblemFactRemoved(Object var1);
}

