/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.EnumeratingJoiners;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.UniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.TerminalEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.AbstractUniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.ForEachIncludingPinnedEnumeratingStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EnumeratingStreamFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final EnvironmentMode environmentMode;
    private final Map<AbstractEnumeratingStream<Solution_>, AbstractEnumeratingStream<Solution_>> sharingStreamMap = new HashMap<AbstractEnumeratingStream<Solution_>, AbstractEnumeratingStream<Solution_>>(256);

    public EnumeratingStreamFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
        this.environmentMode = Objects.requireNonNull(environmentMode);
    }

    public <A> UniEnumeratingStream<Solution_, A> forEachNonDiscriminating(Class<A> sourceClass, boolean includeNull) {
        this.assertValidForEachType(sourceClass);
        return this.share(new ForEachIncludingPinnedEnumeratingStream(this, sourceClass, includeNull));
    }

    public <A> UniEnumeratingStream<Solution_, A> forEachExcludingPinned(Class<A> sourceClass, boolean includeNull) {
        this.assertValidForEachType(sourceClass);
        if (!this.solutionDescriptor.getMetaModel().hasEntity(sourceClass)) {
            return this.forEachNonDiscriminating(sourceClass, includeNull);
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor == null || !listVariableDescriptor.acceptsValueType(sourceClass)) {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(sourceClass);
            return this.share((AbstractUniEnumeratingStream)this.forEachNonDiscriminating(sourceClass, includeNull).filter(entityDescriptor.getEntityMovablePredicate()));
        }
        EntityDescriptor parentEntityDescriptor = listVariableDescriptor.getEntityDescriptor();
        if (!parentEntityDescriptor.supportsPinning()) {
            throw new UnsupportedOperationException("Impossible state: the list variable (%s) does not support pinning.".formatted(listVariableDescriptor.getVariableName()));
        }
        UniEnumeratingStream<Solution_, A> stream = this.forEachNonDiscriminating(sourceClass, includeNull).ifNotExists(parentEntityDescriptor.getEntityClass(), EnumeratingJoiners.filtering(listVariableDescriptor.getEntityContainsPinnedValuePredicate()));
        return this.share((AbstractUniEnumeratingStream)stream);
    }

    public <A> void assertValidForEachType(Class<A> fromType) {
        Set<Class<?>> problemFactOrEntityClassSet = this.solutionDescriptor.getProblemFactOrEntityClassSet();
        boolean hasMatchingType = problemFactOrEntityClassSet.stream().anyMatch(factType -> fromType.isAssignableFrom((Class<?>)factType) || factType.isAssignableFrom(fromType));
        if (!hasMatchingType) {
            List<String> canonicalClassNameList = problemFactOrEntityClassSet.stream().map(Class::getCanonicalName).sorted().toList();
            throw new IllegalArgumentException("Cannot use class (%s) in an enumerating stream as it is neither the same as, nor a superclass or superinterface of one of planning entities or problem facts.\nEnsure that all forEach(), join(), ifExists() and ifNotExists() building blocks only reference classes assignable from planning entities or problem facts (%s) annotated on the planning solution (%s).".formatted(fromType.getCanonicalName(), canonicalClassNameList, this.solutionDescriptor.getSolutionClass().getCanonicalName()));
        }
    }

    public <Stream_ extends AbstractEnumeratingStream<Solution_>> Stream_ share(Stream_ stream) {
        return (Stream_)this.share(stream, t -> {});
    }

    public <Stream_ extends AbstractEnumeratingStream<Solution_>> Stream_ share(Stream_ stream, Consumer<Stream_> consumer) {
        return (Stream_)this.sharingStreamMap.computeIfAbsent(stream, k -> {
            consumer.accept(stream);
            return stream;
        });
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public List<AbstractDataset<Solution_, ?>> getDatasets() {
        return this.sharingStreamMap.values().stream().flatMap(s -> {
            if (s instanceof TerminalEnumeratingStream) {
                TerminalEnumeratingStream terminalStream = (TerminalEnumeratingStream)((Object)s);
                return Stream.of(terminalStream.getDataset());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }
}

