/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public final class FromEntitySortingValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements ValueSelector<Solution_> {
    private final ValueSelector<Solution_> childValueSelector;
    private final SelectionCacheType cacheType;
    private final SelectionSorter<Solution_, Object> sorter;
    private ScoreDirector<Solution_> scoreDirector = null;

    public FromEntitySortingValueSelector(ValueSelector<Solution_> childValueSelector, SelectionCacheType cacheType, SelectionSorter<Solution_, Object> sorter) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        this.sorter = sorter;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childValueSelector (" + String.valueOf(childValueSelector) + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        if (cacheType != SelectionCacheType.STEP) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") does not support the cacheType (" + String.valueOf((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    public ValueSelector<Solution_> getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        long childSize = this.childValueSelector.getSize(entity);
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") has a childValueSelector (" + String.valueOf(this.childValueSelector) + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        ArrayList cachedValueList = new ArrayList((int)childSize);
        this.childValueSelector.iterator(entity).forEachRemaining(cachedValueList::add);
        this.logger.trace("    Created cachedValueList: size ({}), valueSelector ({}).", (Object)cachedValueList.size(), (Object)this);
        this.sorter.sort(this.scoreDirector, cachedValueList);
        this.logger.trace("    Sorted cachedValueList: size ({}), valueSelector ({}).", (Object)cachedValueList.size(), (Object)this);
        return cachedValueList.iterator();
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.iterator(entity);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FromEntitySortingValueSelector that = (FromEntitySortingValueSelector)other;
        return Objects.equals(this.childValueSelector, that.childValueSelector) && this.cacheType == that.cacheType && Objects.equals(this.sorter, that.sorter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.childValueSelector, this.cacheType, this.sorter});
    }

    public String toString() {
        return "Sorting(" + String.valueOf(this.childValueSelector) + ")";
    }
}

