/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.BaseTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedStatus;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultTopologicalOrderGraph
implements TopologicalOrderGraph {
    private final BaseTopologicalOrderGraph.NodeTopologicalOrder[] nodeIdToTopologicalOrderMap;
    private final Map<Integer, List<Integer>> componentMap;
    private final Set<Integer>[] forwardEdges;
    private final Set<Integer>[] backEdges;
    private final boolean[] isNodeInLoopedComponent;

    public DefaultTopologicalOrderGraph(int size) {
        this.nodeIdToTopologicalOrderMap = new BaseTopologicalOrderGraph.NodeTopologicalOrder[size];
        this.componentMap = CollectionUtils.newLinkedHashMap(size);
        this.forwardEdges = new Set[size];
        this.backEdges = new Set[size];
        this.isNodeInLoopedComponent = new boolean[size];
        for (int i = 0; i < size; ++i) {
            this.forwardEdges[i] = new HashSet<Integer>();
            this.backEdges[i] = new HashSet<Integer>();
            this.isNodeInLoopedComponent[i] = false;
            this.nodeIdToTopologicalOrderMap[i] = new BaseTopologicalOrderGraph.NodeTopologicalOrder(i, i);
        }
    }

    List<Integer> getComponent(int node) {
        return this.componentMap.get(node);
    }

    List<List<Integer>> getLoopedComponentList() {
        ArrayList<List<Integer>> out = new ArrayList<List<Integer>>(this.componentMap.size());
        boolean[] visited = new boolean[this.forwardEdges.length];
        for (List<Integer> component : this.componentMap.values()) {
            if (component.size() < 2 || visited[component.get(0)]) continue;
            visited[component.get((int)0).intValue()] = true;
            out.add(component);
        }
        return out;
    }

    @Override
    public void addEdge(int fromNode, int toNode) {
        this.forwardEdges[fromNode].add(toNode);
        this.backEdges[toNode].add(fromNode);
    }

    @Override
    public void removeEdge(int fromNode, int toNode) {
        this.forwardEdges[fromNode].remove(toNode);
        this.backEdges[toNode].remove(fromNode);
    }

    @Override
    public void forEachEdge(TopologicalOrderGraph.EdgeConsumer edgeConsumer) {
        for (int fromNode = 0; fromNode < this.forwardEdges.length; ++fromNode) {
            for (Integer toNode : this.forwardEdges[fromNode]) {
                edgeConsumer.accept(fromNode, toNode);
            }
        }
    }

    @Override
    public PrimitiveIterator.OfInt nodeForwardEdges(int fromNode) {
        return this.componentMap.get(fromNode).stream().flatMap(member -> this.forwardEdges[member].stream()).mapToInt(Integer::intValue).distinct().iterator();
    }

    @Override
    public boolean isLooped(LoopedTracker loopedTracker, int node) {
        return switch (loopedTracker.status(node)) {
            default -> throw new IncompatibleClassChangeError();
            case LoopedStatus.UNKNOWN -> {
                if (this.componentMap.get(node).size() > 1) {
                    loopedTracker.mark(node, LoopedStatus.LOOPED);
                    yield true;
                }
                for (Integer backEdge : this.backEdges[node]) {
                    if (!this.isLooped(loopedTracker, backEdge)) continue;
                    loopedTracker.mark(node, LoopedStatus.LOOPED);
                    yield true;
                }
                loopedTracker.mark(node, LoopedStatus.NOT_LOOPED);
                yield false;
            }
            case LoopedStatus.NOT_LOOPED -> false;
            case LoopedStatus.LOOPED -> true;
        };
    }

    @Override
    public BaseTopologicalOrderGraph.NodeTopologicalOrder getTopologicalOrder(int node) {
        return this.nodeIdToTopologicalOrderMap[node];
    }

    @Override
    public void commitChanges(BitSet changed) {
        MutableInt index = new MutableInt(1);
        MutableInt stackIndex = new MutableInt(0);
        int size = this.forwardEdges.length;
        int[] stack = new int[size];
        int[] indexMap = new int[size];
        int[] lowMap = new int[size];
        boolean[] onStackSet = new boolean[size];
        ArrayList<BitSet> components = new ArrayList<BitSet>();
        this.componentMap.clear();
        for (int node = 0; node < size; ++node) {
            if (indexMap[node] != 0) continue;
            this.strongConnect(node, index, stackIndex, stack, indexMap, lowMap, onStackSet, components);
        }
        int ordIndex = 0;
        block1: for (int i = components.size() - 1; i >= 0; --i) {
            BitSet component = (BitSet)components.get(i);
            int componentSize = component.cardinality();
            boolean isComponentLooped = componentSize != 1;
            ArrayList<Integer> componentNodes = new ArrayList<Integer>(componentSize);
            int node = component.nextSetBit(0);
            while (node >= 0) {
                this.nodeIdToTopologicalOrderMap[node] = new BaseTopologicalOrderGraph.NodeTopologicalOrder(node, ordIndex);
                componentNodes.add(node);
                this.componentMap.put(node, componentNodes);
                if (isComponentLooped != this.isNodeInLoopedComponent[node]) {
                    this.isNodeInLoopedComponent[node] = isComponentLooped;
                    changed.set(node);
                }
                ++ordIndex;
                if (node == Integer.MAX_VALUE) continue block1;
                node = component.nextSetBit(node + 1);
            }
        }
    }

    private void strongConnect(int node, MutableInt index, MutableInt stackIndex, int[] stack, int[] indexMap, int[] lowMap, boolean[] onStackSet, List<BitSet> components) {
        indexMap[node] = index.intValue();
        lowMap[node] = index.intValue();
        index.increment();
        stack[stackIndex.intValue()] = node;
        onStackSet[node] = true;
        stackIndex.increment();
        for (Integer successor : this.forwardEdges[node]) {
            if (indexMap[successor] == 0) {
                this.strongConnect(successor, index, stackIndex, stack, indexMap, lowMap, onStackSet, components);
                lowMap[node] = Math.min(lowMap[node], lowMap[successor]);
                continue;
            }
            if (!onStackSet[successor]) continue;
            lowMap[node] = Math.min(lowMap[node], indexMap[successor]);
        }
        if (onStackSet[node] && lowMap[node] == indexMap[node]) {
            int current;
            BitSet out = new BitSet();
            do {
                current = stack[stackIndex.decrement()];
                onStackSet[current] = false;
                out.set(current);
            } while (node != current);
            components.add(out);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("DefaultTopologicalOrderGraph{\n");
        for (int node = 0; node < this.forwardEdges.length; ++node) {
            out.append("    ").append(node).append("(").append(this.nodeIdToTopologicalOrderMap[node].order()).append(") -> ").append(this.forwardEdges[node].stream().sorted().map(Object::toString).collect(Collectors.joining(",", "[", "]\n")));
        }
        out.append("}");
        return out.toString();
    }
}

