/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner.gizmo;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerClassOutput;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GizmoSolutionClonerImplementor {
    private static final MethodDescriptor EQUALS_METHOD = MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class});
    protected static final MethodDescriptor GET_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final String FALLBACK_CLONER = "fallbackCloner";
    public static final boolean DEBUG = false;

    public static Comparator<Class<?>> getInstanceOfComparator(Set<Class<?>> deepClonedClassSet) {
        HashMap classToSubclassLevel = new HashMap();
        deepClonedClassSet.forEach(clazz -> {
            if (deepClonedClassSet.stream().allMatch(otherClazz -> clazz.isAssignableFrom((Class<?>)otherClazz) || !otherClazz.isAssignableFrom((Class<?>)clazz))) {
                classToSubclassLevel.put(clazz, 0);
            }
        });
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Class<?> clazz2 : deepClonedClassSet) {
                isChanged |= classToSubclassLevel.keySet().stream().filter(otherClazz -> otherClazz != clazz2 && otherClazz.isAssignableFrom(clazz2)).map(classToSubclassLevel::get).max(Integer::compare).map(subclassLevel -> {
                    int oldVal = classToSubclassLevel.getOrDefault(clazz2, -1);
                    int newVal = subclassLevel + 1;
                    if (newVal > oldVal) {
                        classToSubclassLevel.put(clazz2, newVal);
                        return true;
                    }
                    return false;
                }).orElse(false).booleanValue();
            }
        }
        return Comparator.comparing(classToSubclassLevel::get).thenComparing(Class::getName).reversed();
    }

    protected void createFields(ClonerDescriptor clonerDescriptor) {
        clonerDescriptor.classCreator.getFieldCreator(FALLBACK_CLONER, FieldAccessingSolutionCloner.class).setModifiers(10);
    }

    public static void defineClonerFor(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        GizmoSolutionClonerImplementor.defineClonerFor(GizmoSolutionClonerImplementor::new, classCreator, solutionDescriptor, solutionClassSet, memoizedSolutionOrEntityDescriptorMap, deepClonedClassSet);
    }

    public static boolean isCloneableClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static void defineClonerFor(Supplier<GizmoSolutionClonerImplementor> implementorSupplier, ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        GizmoSolutionClonerImplementor implementor = implementorSupplier.get();
        Set deepCloneClassesThatAreNotSolutionSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(GizmoSolutionClonerImplementor::isCloneableClass).collect(Collectors.toSet());
        Comparator<Class<?>> instanceOfComparator = GizmoSolutionClonerImplementor.getInstanceOfComparator(deepClonedClassSet);
        TreeSet deepCloneClassesThatAreNotSolutionSortedSet = new TreeSet(instanceOfComparator);
        deepCloneClassesThatAreNotSolutionSortedSet.addAll(deepCloneClassesThatAreNotSolutionSet);
        ClonerDescriptor clonerDescriptor = new ClonerDescriptor(solutionDescriptor, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet, classCreator);
        implementor.createFields(clonerDescriptor);
        implementor.createSetSolutionDescriptor(clonerDescriptor);
        GizmoSolutionClonerImplementor.createCloneSolutionRun(clonerDescriptor, solutionClassSet, instanceOfComparator);
        GizmoSolutionClonerImplementor.createConstructor(clonerDescriptor);
        GizmoSolutionClonerImplementor.createCloneSolution(clonerDescriptor);
        for (Class<?> deepClonedClass : deepCloneClassesThatAreNotSolutionSortedSet) {
            implementor.createDeepCloneHelperMethod(clonerDescriptor, deepClonedClass);
        }
        Set abstractDeepCloneClassSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(Predicate.not(GizmoSolutionClonerImplementor::isCloneableClass)).collect(Collectors.toSet());
        for (Class abstractDeepClonedClass : abstractDeepCloneClassSet) {
            implementor.createAbstractDeepCloneHelperMethod(clonerDescriptor, abstractDeepClonedClass);
        }
    }

    public static ClassOutput createClassOutputWithDebuggingCapability(Map<String, byte[]> classBytecodeHolder) {
        return new GizmoSolutionClonerClassOutput(classBytecodeHolder);
    }

    static <T> SolutionCloner<T> createClonerFor(SolutionDescriptor<T> solutionDescriptor, GizmoClassLoader gizmoClassLoader) {
        GizmoSolutionClonerImplementor implementor = new GizmoSolutionClonerImplementor();
        String className = GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor);
        if (gizmoClassLoader.hasBytecodeFor(className)) {
            return implementor.createInstance(className, gizmoClassLoader, solutionDescriptor);
        }
        HashMap<String, byte[]> classBytecodeHolder = new HashMap<String, byte[]>();
        ClassCreator classCreator = ClassCreator.builder().className(className).interfaces(new Class[]{GizmoSolutionCloner.class}).superClass(Object.class).classOutput(GizmoSolutionClonerImplementor.createClassOutputWithDebuggingCapability(classBytecodeHolder)).setFinal(true).build();
        Set<Class<?>> deepClonedClassSet = GizmoCloningUtils.getDeepClonedClasses(solutionDescriptor, Collections.emptyList());
        GizmoSolutionClonerImplementor.defineClonerFor(() -> implementor, classCreator, solutionDescriptor, Collections.singleton(solutionDescriptor.getSolutionClass()), new HashMap(), deepClonedClassSet);
        classCreator.close();
        for (Map.Entry<String, byte[]> bytecodeEntry : classBytecodeHolder.entrySet()) {
            gizmoClassLoader.storeBytecode(bytecodeEntry.getKey(), bytecodeEntry.getValue());
        }
        return implementor.createInstance(className, gizmoClassLoader, solutionDescriptor);
    }

    private <T> SolutionCloner<T> createInstance(String className, ClassLoader gizmoClassLoader, SolutionDescriptor<T> solutionDescriptor) {
        try {
            Class<?> outClass = gizmoClassLoader.loadClass(className);
            GizmoSolutionCloner out = (GizmoSolutionCloner)outClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            out.setSolutionDescriptor(solutionDescriptor);
            return out;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createConstructor(ClonerDescriptor clonerDescriptor) {
        MethodCreator methodCreator = clonerDescriptor.classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)clonerDescriptor.classCreator.getClassName(), (String[])new String[0]));
        ResultHandle thisObj = methodCreator.getThis();
        methodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
        methodCreator.returnValue(thisObj);
    }

    protected void createSetSolutionDescriptor(ClonerDescriptor clonerDescriptor) {
        MethodCreator methodCreator = clonerDescriptor.classCreator.getMethodCreator(MethodDescriptor.ofMethod(GizmoSolutionCloner.class, (String)"setSolutionDescriptor", Void.TYPE, (Class[])new Class[]{SolutionDescriptor.class}));
        methodCreator.writeStaticField(FieldDescriptor.of((String)GizmoSolutionClonerFactory.getGeneratedClassName(clonerDescriptor.solutionDescriptor), (String)FALLBACK_CLONER, FieldAccessingSolutionCloner.class), methodCreator.newInstance(MethodDescriptor.ofConstructor(FieldAccessingSolutionCloner.class, (Class[])new Class[]{SolutionDescriptor.class}), new ResultHandle[]{methodCreator.getMethodParam(0)}));
        methodCreator.returnValue(null);
    }

    private static void createCloneSolution(ClonerDescriptor clonerDescriptor) {
        Class<?> solutionClass = clonerDescriptor.solutionDescriptor.getSolutionClass();
        MethodCreator methodCreator = clonerDescriptor.classCreator.getMethodCreator(MethodDescriptor.ofMethod(SolutionCloner.class, (String)"cloneSolution", Object.class, (Class[])new Class[]{Object.class}));
        ResultHandle thisObj = methodCreator.getMethodParam(0);
        ResultHandle clone = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(clonerDescriptor.solutionDescriptor), (String)"cloneSolutionRun", solutionClass, (Object[])new Object[]{solutionClass, Map.class}), new ResultHandle[]{thisObj, methodCreator.newInstance(MethodDescriptor.ofConstructor(IdentityHashMap.class, (Class[])new Class[0]), new ResultHandle[0])});
        methodCreator.returnValue(clone);
    }

    private static void createCloneSolutionRun(ClonerDescriptor clonerDescriptor, Set<Class<?>> solutionClassSet, Comparator<Class<?>> instanceOfComparator) {
        Class<?> solutionClass = clonerDescriptor.solutionDescriptor.getSolutionClass();
        MethodCreator methodCreator = clonerDescriptor.classCreator.getMethodCreator("cloneSolutionRun", solutionClass, new Class[]{solutionClass, Map.class});
        methodCreator.setModifiers(9);
        ResultHandle thisObj = methodCreator.getMethodParam(0);
        BranchResult solutionNullBranchResult = methodCreator.ifNull(thisObj);
        try (BytecodeCreator solutionIsNullBranch = solutionNullBranchResult.trueBranch();){
            solutionIsNullBranch.returnValue(thisObj);
        }
        try (BytecodeCreator solutionIsNotNullBranch = solutionNullBranchResult.falseBranch();){
            ResultHandle createdCloneMap = methodCreator.getMethodParam(1);
            ResultHandle maybeClone = solutionIsNotNullBranch.invokeInterfaceMethod(GET_METHOD, createdCloneMap, new ResultHandle[]{thisObj});
            BranchResult hasCloneBranchResult = solutionIsNotNullBranch.ifNotNull(maybeClone);
            try (BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();){
                hasCloneBranch.returnValue(maybeClone);
            }
            BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
            ArrayList sortedSolutionClassList = new ArrayList(solutionClassSet);
            sortedSolutionClassList.sort(instanceOfComparator);
            BytecodeCreator currentBranch = noCloneBranch;
            ResultHandle thisObjClass = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"getClass", Class.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
            for (Class<?> solutionSubclass : sortedSolutionClassList) {
                ResultHandle clone;
                ResultHandle solutionSubclassResultHandle = currentBranch.loadClass(solutionSubclass);
                ResultHandle isSubclass = currentBranch.invokeVirtualMethod(EQUALS_METHOD, solutionSubclassResultHandle, new ResultHandle[]{thisObjClass});
                BranchResult isSubclassBranchResult = currentBranch.ifTrue(isSubclass);
                BytecodeCreator isSubclassBranch = isSubclassBranchResult.trueBranch();
                GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor = clonerDescriptor.memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(solutionSubclass, key -> new GizmoSolutionOrEntityDescriptor(clonerDescriptor.solutionDescriptor, solutionSubclass));
                if (PlanningCloneable.class.isAssignableFrom(solutionSubclass)) {
                    clone = isSubclassBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
                    clone = isSubclassBranch.checkCast(clone, solutionSubclass);
                } else {
                    clone = isSubclassBranch.newInstance(MethodDescriptor.ofConstructor(solutionSubclass, (Class[])new Class[0]), new ResultHandle[0]);
                }
                isSubclassBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), createdCloneMap, new ResultHandle[]{thisObj, clone});
                GizmoSolutionClonerImplementor.cloneShallowlyClonedFieldsOfObject(solutionSubclassDescriptor, clonerDescriptor, new ClonerMethodDescriptor(solutionSubclassDescriptor, isSubclassBranch, createdCloneMap, true, isSubclassBranch.newInstance(MethodDescriptor.ofConstructor(ArrayDeque.class, (Class[])new Class[0]), new ResultHandle[0])), thisObj, clone);
                GizmoSolutionClonerImplementor.cloneDeepClonedFieldsOfSolution(clonerDescriptor, solutionSubclassDescriptor, isSubclassBranch, thisObj, createdCloneMap, clone);
                isSubclassBranch.returnValue(clone);
                currentBranch.close();
                currentBranch = isSubclassBranchResult.falseBranch();
            }
            ResultHandle errorBuilder = currentBranch.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{currentBranch.load("Failed to create clone: encountered (")});
            String errorTemplate = "which is not a known subclass of the solution class (%s).\nThe known subclasses are: %s.\nMaybe use DomainAccessType.REFLECTION?\n".formatted(clonerDescriptor.solutionDescriptor.getSolutionClass(), solutionClassSet.stream().map(Class::getName).collect(Collectors.joining(", ", "[", "]")));
            MethodDescriptor APPEND = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class});
            currentBranch.invokeVirtualMethod(APPEND, errorBuilder, new ResultHandle[]{thisObjClass});
            currentBranch.invokeVirtualMethod(APPEND, errorBuilder, new ResultHandle[]{currentBranch.load(") " + errorTemplate)});
            ResultHandle errorMsg = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), errorBuilder, new ResultHandle[0]);
            ResultHandle error = currentBranch.newInstance(MethodDescriptor.ofConstructor(IllegalArgumentException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{errorMsg});
            currentBranch.throwException(error);
            currentBranch.close();
        }
    }

    private static void cloneDeepClonedFieldsOfSolution(ClonerDescriptor clonerDescriptor, GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor, BytecodeCreator isSubclassBranch, ResultHandle thisObj, ResultHandle createdCloneMap, ResultHandle clone) {
        for (Field deeplyClonedField : solutionSubclassDescriptor.getDeepClonedFields()) {
            GizmoMemberDescriptor gizmoMemberDescriptor = solutionSubclassDescriptor.getMemberDescriptorForField(deeplyClonedField);
            ResultHandle fieldValue = gizmoMemberDescriptor.readMemberValue(isSubclassBranch, thisObj);
            AssignableResultHandle cloneValue = isSubclassBranch.createVariable(deeplyClonedField.getType());
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, new ClonerMethodDescriptor(solutionSubclassDescriptor, isSubclassBranch, createdCloneMap, true, isSubclassBranch.newInstance(MethodDescriptor.ofConstructor(ArrayDeque.class, (Class[])new Class[0]), new ResultHandle[0])), deeplyClonedField, gizmoMemberDescriptor, fieldValue, cloneValue);
            if (gizmoMemberDescriptor.writeMemberValue(isSubclassBranch, clone, (ResultHandle)cloneValue)) continue;
            throw new IllegalStateException("The member (%s) of class (%s) does not have a setter.".formatted(gizmoMemberDescriptor.getName(), gizmoMemberDescriptor.getDeclaringClassName()));
        }
    }

    private static void cloneShallowlyClonedFieldsOfObject(GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor, ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor solutionSubclassDescriptor1, ResultHandle thisObj, ResultHandle clone) {
        for (GizmoMemberDescriptor shallowlyClonedField : solutionSubclassDescriptor.getShallowClonedMemberDescriptors()) {
            GizmoSolutionClonerImplementor.writeShallowCloneInstructions(clonerDescriptor, solutionSubclassDescriptor1, shallowlyClonedField, thisObj, clone);
        }
    }

    private static void writeShallowCloneInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, GizmoMemberDescriptor shallowlyClonedField, ResultHandle thisObj, ResultHandle clone) {
        try {
            boolean isArray = shallowlyClonedField.getTypeName().endsWith("[]");
            Class<?> type = null;
            if (shallowlyClonedField.getType() instanceof Class) {
                type = (Class<?>)shallowlyClonedField.getType();
            }
            List<Object> entitySubclasses = Collections.emptyList();
            if (type == null && !isArray) {
                type = Class.forName(shallowlyClonedField.getTypeName().replace('/', '.'), false, Thread.currentThread().getContextClassLoader());
            }
            if (type != null && !isArray) {
                entitySubclasses = clonerDescriptor.deepClonedClassesSortedSet.stream().filter(type::isAssignableFrom).toList();
            }
            ResultHandle fieldValue = shallowlyClonedField.readMemberValue(clonerMethodDescriptor.bytecodeCreator, thisObj);
            if (!entitySubclasses.isEmpty()) {
                AssignableResultHandle cloneResultHolder = clonerMethodDescriptor.bytecodeCreator.createVariable(type);
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor, type, fieldValue, cloneResultHolder, UnhandledCloneType.SHALLOW);
                fieldValue = cloneResultHolder;
            }
            if (!shallowlyClonedField.writeMemberValue(clonerMethodDescriptor.bytecodeCreator, clone, fieldValue)) {
                throw new IllegalStateException("Field (%s) of class (%s) does not have a setter.".formatted(shallowlyClonedField.getName(), shallowlyClonedField.getDeclaringClassName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Error creating Gizmo Solution Cloner", e);
        }
    }

    private static void writeDeepCloneInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Field deeplyClonedField, GizmoMemberDescriptor gizmoMemberDescriptor, ResultHandle toClone, AssignableResultHandle cloneResultHolder) {
        BranchResult isNull = clonerMethodDescriptor.bytecodeCreator.ifNull(toClone);
        try (BytecodeCreator isNullBranch = isNull.trueBranch();){
            isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        }
        try (BytecodeCreator isNotNullBranch = isNull.falseBranch();){
            Class<?> deeplyClonedFieldClass = deeplyClonedField.getType();
            Type type = gizmoMemberDescriptor.getType();
            if (clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneSolutionInstructions(clonerMethodDescriptor, toClone, cloneResultHolder);
            } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneCollectionInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneMapInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (deeplyClonedFieldClass.isArray()) {
                GizmoSolutionClonerImplementor.writeDeepCloneArrayInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder);
            } else {
                UnhandledCloneType unknownClassCloneType = DeepCloningUtils.isFieldDeepCloned(clonerMethodDescriptor.entityDescriptor.solutionDescriptor, deeplyClonedField, deeplyClonedField.getDeclaringClass()) ? UnhandledCloneType.DEEP : UnhandledCloneType.SHALLOW;
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder, unknownClassCloneType);
            }
        }
    }

    private static void writeDeepCloneInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder) {
        BranchResult isNull = clonerMethodDescriptor.bytecodeCreator.ifNull(toClone);
        try (BytecodeCreator isNullBranch = isNull.trueBranch();){
            isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        }
        try (BytecodeCreator isNotNullBranch = isNull.falseBranch();){
            if (clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneSolutionInstructions(clonerMethodDescriptor, toClone, cloneResultHolder);
            } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneCollectionInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
                GizmoSolutionClonerImplementor.writeDeepCloneMapInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, type, toClone, cloneResultHolder);
            } else if (deeplyClonedFieldClass.isArray()) {
                GizmoSolutionClonerImplementor.writeDeepCloneArrayInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder);
            } else {
                UnhandledCloneType unknownClassCloneType = DeepCloningUtils.isClassDeepCloned(clonerMethodDescriptor.entityDescriptor.solutionDescriptor, deeplyClonedFieldClass) ? UnhandledCloneType.DEEP : UnhandledCloneType.SHALLOW;
                GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(isNotNullBranch), deeplyClonedFieldClass, toClone, cloneResultHolder, unknownClassCloneType);
            }
        }
    }

    private static void writeDeepCloneSolutionInstructions(ClonerMethodDescriptor clonerMethodDescriptor, ResultHandle toClone, AssignableResultHandle cloneResultHolder) {
        BranchResult isNull = clonerMethodDescriptor.bytecodeCreator.ifNull(toClone);
        try (BytecodeCreator isNullBranch = isNull.trueBranch();){
            isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        }
        try (BytecodeCreator isNotNullBranch = isNull.falseBranch();){
            ResultHandle clone = isNotNullBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor()), (String)"cloneSolutionRun", clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass(), (Object[])new Object[]{clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor().getSolutionClass(), Map.class}), new ResultHandle[]{toClone, clonerMethodDescriptor.createdCloneMap});
            isNotNullBranch.assign(cloneResultHolder, clone);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeDeepCloneCollectionInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder) {
        BytecodeCreator bytecodeCreator = clonerMethodDescriptor.bytecodeCreator;
        AssignableResultHandle cloneCollection = bytecodeCreator.createVariable(deeplyClonedFieldClass);
        ResultHandle size = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Collection.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        if (PlanningCloneable.class.isAssignableFrom(deeplyClonedFieldClass)) {
            ResultHandle emptyInstance = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), bytecodeCreator.checkCast(toClone, PlanningCloneable.class), new ResultHandle[0]);
            bytecodeCreator.assign(cloneCollection, bytecodeCreator.checkCast(emptyInstance, Collection.class));
        } else if (List.class.isAssignableFrom(deeplyClonedFieldClass)) {
            bytecodeCreator.assign(cloneCollection, bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        } else {
            if (Set.class.isAssignableFrom(deeplyClonedFieldClass)) {
                ResultHandle isSortedSet = bytecodeCreator.instanceOf(toClone, SortedSet.class);
                BranchResult isSortedSetBranchResult = bytecodeCreator.ifTrue(isSortedSet);
                try (BytecodeCreator isSortedSetBranch = isSortedSetBranchResult.trueBranch();){
                    ResultHandle setComparator = isSortedSetBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(SortedSet.class, (String)"comparator", Comparator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
                    isSortedSetBranch.assign(cloneCollection, isSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[]{Comparator.class}), new ResultHandle[]{setComparator}));
                }
                try (BytecodeCreator isNotSortedSetBranch = isSortedSetBranchResult.falseBranch();){
                    isNotSortedSetBranch.assign(cloneCollection, isNotSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
                }
            }
            ResultHandle isSet = bytecodeCreator.instanceOf(toClone, Set.class);
            BranchResult isSetBranchResult = bytecodeCreator.ifTrue(isSet);
            try (BytecodeCreator isSetBranch = isSetBranchResult.trueBranch();){
                ResultHandle isSortedSet = isSetBranch.instanceOf(toClone, SortedSet.class);
                BranchResult isSortedSetBranchResult = isSetBranch.ifTrue(isSortedSet);
                try (BytecodeCreator isSortedSetBranch = isSortedSetBranchResult.trueBranch();){
                    ResultHandle setComparator = isSortedSetBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(SortedSet.class, (String)"comparator", Comparator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
                    isSortedSetBranch.assign(cloneCollection, isSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[]{Comparator.class}), new ResultHandle[]{setComparator}));
                }
                try (BytecodeCreator isNotSortedSetBranch = isSortedSetBranchResult.falseBranch();){
                    isNotSortedSetBranch.assign(cloneCollection, isNotSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
                }
            }
            try (BytecodeCreator isNotSetBranch = isSetBranchResult.falseBranch();){
                isNotSetBranch.assign(cloneCollection, isNotSetBranch.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
            }
        }
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        try (BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> {
            ResultHandle hasNext = conditionBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            return conditionBytecode.ifTrue(hasNext);
        }).block();){
            Class elementClass;
            if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Collection type (%s).".formatted(type));
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type elementClassType = parameterizedType.getActualTypeArguments()[0];
            if (elementClassType instanceof Class) {
                Class class1;
                elementClass = class1 = (Class)elementClassType;
            } else if (elementClassType instanceof ParameterizedType) {
                ParameterizedType parameterizedElementClassType = (ParameterizedType)elementClassType;
                elementClass = (Class)parameterizedElementClassType.getRawType();
            } else {
                if (!(elementClassType instanceof WildcardType)) throw new IllegalStateException("Unhandled type (%s).".formatted(elementClassType));
                WildcardType wildcardType = (WildcardType)elementClassType;
                elementClass = (Class)wildcardType.getUpperBounds()[0];
            }
            ResultHandle next = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            AssignableResultHandle clonedElement = whileLoopBlock.createVariable(elementClass);
            GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(whileLoopBlock), elementClass, elementClassType, next, clonedElement);
            whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Collection.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), (ResultHandle)cloneCollection, new ResultHandle[]{clonedElement});
        }
        bytecodeCreator.assign(cloneResultHolder, (ResultHandle)cloneCollection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeDeepCloneMapInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder) {
        Class keyClass;
        Class elementClass;
        ResultHandle cloneMap;
        BytecodeCreator bytecodeCreator = clonerMethodDescriptor.bytecodeCreator;
        if (PlanningCloneable.class.isAssignableFrom(deeplyClonedFieldClass)) {
            ResultHandle emptyInstance = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), bytecodeCreator.checkCast(toClone, PlanningCloneable.class), new ResultHandle[0]);
            cloneMap = bytecodeCreator.checkCast(emptyInstance, Map.class);
        } else {
            Class<Object> holderClass = deeplyClonedFieldClass;
            try {
                holderClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                holderClass = LinkedHashMap.class.isAssignableFrom(holderClass) ? LinkedHashMap.class : (ConcurrentHashMap.class.isAssignableFrom(holderClass) ? ConcurrentHashMap.class : LinkedHashMap.class);
            }
            ResultHandle size = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            try {
                holderClass.getConstructor(Integer.TYPE);
                cloneMap = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(holderClass, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size});
            }
            catch (NoSuchMethodException e) {
                cloneMap = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(holderClass, (Class[])new Class[0]), new ResultHandle[0]);
            }
        }
        ResultHandle entrySet = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"entrySet", Set.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), entrySet, new ResultHandle[0]);
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> {
            ResultHandle hasNext = conditionBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            return conditionBytecode.ifTrue(hasNext);
        }).block();
        if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Map type (%s).".formatted(type));
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type keyType = parameterizedType.getActualTypeArguments()[0];
        Type elementClassType = parameterizedType.getActualTypeArguments()[1];
        if (elementClassType instanceof Class) {
            Class class1;
            elementClass = class1 = (Class)elementClassType;
        } else {
            if (!(elementClassType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type (%s).".formatted(elementClassType));
            ParameterizedType parameterizedElementClassType = (ParameterizedType)elementClassType;
            elementClass = (Class)parameterizedElementClassType.getRawType();
        }
        if (keyType instanceof Class) {
            Class class1;
            keyClass = class1 = (Class)keyType;
        } else {
            if (!(keyType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type (%s).".formatted(keyType));
            ParameterizedType parameterizedElementClassType = (ParameterizedType)keyType;
            keyClass = (Class)parameterizedElementClassType.getRawType();
        }
        List<Class> entitySubclasses = clonerDescriptor.deepClonedClassesSortedSet.stream().filter(keyClass::isAssignableFrom).toList();
        ResultHandle entry = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
        ResultHandle toCloneValue = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getValue", Object.class, (Class[])new Class[0]), entry, new ResultHandle[0]);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(elementClass);
        GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(whileLoopBlock), elementClass, elementClassType, toCloneValue, clonedElement);
        ResultHandle key = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getKey", Object.class, (Class[])new Class[0]), entry, new ResultHandle[0]);
        if (!entitySubclasses.isEmpty()) {
            AssignableResultHandle keyCloneResultHolder = whileLoopBlock.createVariable(keyClass);
            GizmoSolutionClonerImplementor.writeDeepCloneEntityOrFactInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(whileLoopBlock), keyClass, key, keyCloneResultHolder, UnhandledCloneType.DEEP);
            whileLoopBlock.invokeInterfaceMethod(PUT_METHOD, cloneMap, new ResultHandle[]{keyCloneResultHolder, clonedElement});
        } else {
            whileLoopBlock.invokeInterfaceMethod(PUT_METHOD, cloneMap, new ResultHandle[]{key, clonedElement});
        }
        bytecodeCreator.assign(cloneResultHolder, cloneMap);
    }

    private static void writeDeepCloneArrayInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, ResultHandle toClone, AssignableResultHandle cloneResultHolder) {
        BytecodeCreator bytecodeCreator = clonerMethodDescriptor.bytecodeCreator;
        Class<?> arrayComponent = deeplyClonedFieldClass.getComponentType();
        ResultHandle arrayLength = bytecodeCreator.arrayLength(toClone);
        ResultHandle arrayClone = bytecodeCreator.newArray(arrayComponent, arrayLength);
        AssignableResultHandle iterations = bytecodeCreator.createVariable(Integer.TYPE);
        bytecodeCreator.assign(iterations, bytecodeCreator.load(0));
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> conditionBytecode.ifIntegerLessThan((ResultHandle)iterations, arrayLength)).block();
        ResultHandle toCloneElement = whileLoopBlock.readArrayValue(toClone, (ResultHandle)iterations);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(arrayComponent);
        GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(whileLoopBlock), arrayComponent, arrayComponent, toCloneElement, clonedElement);
        whileLoopBlock.writeArrayValue(arrayClone, (ResultHandle)iterations, (ResultHandle)clonedElement);
        whileLoopBlock.assign(iterations, whileLoopBlock.increment((ResultHandle)iterations));
        bytecodeCreator.assign(cloneResultHolder, arrayClone);
    }

    private static void writeDeepCloneEntityOrFactInstructions(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> deeplyClonedFieldClass, ResultHandle toClone, AssignableResultHandle cloneResultHolder, UnhandledCloneType unhandledCloneType) {
        List<Class> deepClonedSubclasses = clonerDescriptor.deepClonedClassesSortedSet.stream().filter(deeplyClonedFieldClass::isAssignableFrom).filter(type -> DeepCloningUtils.isClassDeepCloned(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor(), type)).toList();
        BytecodeCreator currentBranch = clonerMethodDescriptor.bytecodeCreator;
        for (Class deepClonedSubclass : deepClonedSubclasses) {
            ResultHandle isInstance = currentBranch.instanceOf(toClone, deepClonedSubclass);
            BranchResult isInstanceBranchResult = currentBranch.ifTrue(isInstance);
            try (BytecodeCreator isInstanceBranch = isInstanceBranchResult.trueBranch();){
                ResultHandle cloneObj = isInstanceBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor()), (String)GizmoSolutionClonerImplementor.getEntityHelperMethodName(deepClonedSubclass), (Object)deepClonedSubclass, (Object[])new Object[]{deepClonedSubclass, Map.class, Boolean.TYPE, ArrayDeque.class}), new ResultHandle[]{toClone, clonerMethodDescriptor.createdCloneMap, currentBranch.load(clonerMethodDescriptor.isBottom), clonerMethodDescriptor.cloneQueue});
                isInstanceBranch.assign(cloneResultHolder, cloneObj);
            }
            currentBranch.close();
            currentBranch = isInstanceBranchResult.falseBranch();
        }
        switch (unhandledCloneType) {
            case SHALLOW: {
                currentBranch.assign(cloneResultHolder, toClone);
                break;
            }
            case DEEP: {
                ResultHandle cloneObj = currentBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(clonerMethodDescriptor.entityDescriptor.getSolutionDescriptor()), (String)GizmoSolutionClonerImplementor.getEntityHelperMethodName(deeplyClonedFieldClass), deeplyClonedFieldClass, (Object[])new Object[]{deeplyClonedFieldClass, Map.class, Boolean.TYPE, ArrayDeque.class}), new ResultHandle[]{toClone, clonerMethodDescriptor.createdCloneMap, currentBranch.load(clonerMethodDescriptor.isBottom), clonerMethodDescriptor.cloneQueue});
                currentBranch.assign(cloneResultHolder, cloneObj);
            }
        }
        currentBranch.close();
    }

    protected static String getEntityHelperMethodName(Class<?> entityClass) {
        return "$clone" + entityClass.getName().replace('.', '_');
    }

    protected BytecodeCreator createUnknownClassHandler(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Class<?> entityClass, ResultHandle toClone) {
        ResultHandle actualClass = clonerMethodDescriptor.bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"getClass", Class.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        BranchResult branchResult = clonerMethodDescriptor.bytecodeCreator.ifReferencesNotEqual(actualClass, clonerMethodDescriptor.bytecodeCreator.loadClass(entityClass));
        try (BytecodeCreator currentBranch = branchResult.trueBranch();){
            ResultHandle fallbackCloner = currentBranch.readStaticField(FieldDescriptor.of((String)GizmoSolutionClonerFactory.getGeneratedClassName(clonerDescriptor.solutionDescriptor), (String)FALLBACK_CLONER, FieldAccessingSolutionCloner.class));
            ResultHandle cloneObj = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(FieldAccessingSolutionCloner.class, (String)"gizmoFallbackDeepClone", Object.class, (Class[])new Class[]{Object.class, Map.class}), fallbackCloner, new ResultHandle[]{toClone, clonerMethodDescriptor.createdCloneMap});
            currentBranch.returnValue(cloneObj);
        }
        return branchResult.falseBranch();
    }

    private void createDeepCloneHelperMethod(ClonerDescriptor clonerDescriptor, Class<?> entityClass) {
        MethodCreator methodCreator = clonerDescriptor.classCreator.getMethodCreator(GizmoSolutionClonerImplementor.getEntityHelperMethodName(entityClass), entityClass, new Class[]{entityClass, Map.class, Boolean.TYPE, ArrayDeque.class});
        methodCreator.setModifiers(9);
        GizmoSolutionOrEntityDescriptor entityDescriptor = clonerDescriptor.memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(entityClass, key -> new GizmoSolutionOrEntityDescriptor(clonerDescriptor.solutionDescriptor, entityClass));
        ResultHandle toClone = methodCreator.getMethodParam(0);
        ResultHandle cloneMap = methodCreator.getMethodParam(1);
        ResultHandle isBottom = methodCreator.getMethodParam(2);
        ResultHandle cloneQueue = methodCreator.getMethodParam(3);
        ResultHandle maybeClone = methodCreator.invokeInterfaceMethod(GET_METHOD, cloneMap, new ResultHandle[]{toClone});
        BranchResult hasCloneBranchResult = methodCreator.ifNotNull(maybeClone);
        try (BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();){
            hasCloneBranch.returnValue(maybeClone);
        }
        try (BytecodeCreator originalNoCloneBranch = hasCloneBranchResult.falseBranch();
             BytecodeCreator newNoCloneBranch = this.createUnknownClassHandler(clonerDescriptor, new ClonerMethodDescriptor(entityDescriptor, originalNoCloneBranch, cloneMap, false, cloneQueue), entityClass, toClone);){
            ResultHandle cloneObj;
            if (PlanningCloneable.class.isAssignableFrom(entityClass)) {
                cloneObj = newNoCloneBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
                cloneObj = newNoCloneBranch.checkCast(cloneObj, entityClass);
            } else {
                cloneObj = newNoCloneBranch.newInstance(MethodDescriptor.ofConstructor(entityClass, (Class[])new Class[0]), new ResultHandle[0]);
            }
            newNoCloneBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), cloneMap, new ResultHandle[]{toClone, cloneObj});
            ClonerMethodDescriptor clonerMethodDescriptor = new ClonerMethodDescriptor(entityDescriptor, newNoCloneBranch, cloneMap, false, cloneQueue);
            GizmoSolutionClonerImplementor.cloneShallowlyClonedFieldsOfObject(entityDescriptor, clonerDescriptor, clonerMethodDescriptor, toClone, cloneObj);
            for (Field deeplyClonedField : entityDescriptor.getDeepClonedFields()) {
                GizmoSolutionClonerImplementor.addDeepCloneFieldInitializerToQueue(clonerDescriptor, clonerMethodDescriptor, deeplyClonedField, toClone, cloneObj);
            }
            try (BytecodeCreator bottomObjectBranch = newNoCloneBranch.ifTrue(isBottom).trueBranch();
                 BytecodeCreator queueNotEmptyBlock = bottomObjectBranch.whileLoop(condition -> condition.ifFalse(condition.invokeVirtualMethod(MethodDescriptor.ofMethod(ArrayDeque.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), cloneQueue, new ResultHandle[0]))).block();){
                ResultHandle next = queueNotEmptyBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(ArrayDeque.class, (String)"pop", Object.class, (Class[])new Class[0]), cloneQueue, new ResultHandle[0]);
                queueNotEmptyBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(BiConsumer.class, (String)"accept", Void.TYPE, (Class[])new Class[]{Object.class, Object.class}), queueNotEmptyBlock.checkCast(next, BiConsumer.class), new ResultHandle[]{cloneMap, cloneQueue});
            }
            newNoCloneBranch.returnValue(cloneObj);
        }
    }

    private static void addDeepCloneFieldInitializerToQueue(ClonerDescriptor clonerDescriptor, ClonerMethodDescriptor clonerMethodDescriptor, Field deeplyClonedField, ResultHandle toClone, ResultHandle cloneObj) {
        GizmoSolutionOrEntityDescriptor entityDescriptor = clonerMethodDescriptor.entityDescriptor;
        BytecodeCreator bytecodeCreator = clonerMethodDescriptor.bytecodeCreator;
        ResultHandle cloneQueue = clonerMethodDescriptor.cloneQueue;
        GizmoMemberDescriptor gizmoMemberDescriptor = entityDescriptor.getMemberDescriptorForField(deeplyClonedField);
        FunctionCreator consumer = bytecodeCreator.createFunction(BiConsumer.class);
        BytecodeCreator consumerCreator = consumer.getBytecode();
        ResultHandle subfieldValue = gizmoMemberDescriptor.readMemberValue(consumerCreator, toClone);
        AssignableResultHandle cloneValue = consumerCreator.createVariable(deeplyClonedField.getType());
        GizmoSolutionClonerImplementor.writeDeepCloneInstructions(clonerDescriptor, clonerMethodDescriptor.withBytecodeCreator(consumerCreator).withCreatedCloneMap(consumerCreator.getMethodParam(0)).withCloneQueue(consumerCreator.getMethodParam(1)), deeplyClonedField, gizmoMemberDescriptor, subfieldValue, cloneValue);
        if (!gizmoMemberDescriptor.writeMemberValue(consumerCreator, cloneObj, (ResultHandle)cloneValue)) {
            throw new IllegalStateException("The member (%s) of class (%s) does not have a setter.".formatted(gizmoMemberDescriptor.getName(), gizmoMemberDescriptor.getDeclaringClassName()));
        }
        consumerCreator.returnVoid();
        bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ArrayDeque.class, (String)"push", Void.TYPE, (Class[])new Class[]{Object.class}), cloneQueue, new ResultHandle[]{consumer.getInstance()});
    }

    protected void createAbstractDeepCloneHelperMethod(ClonerDescriptor clonerDescriptor, Class<?> entityClass) {
        MethodCreator methodCreator = clonerDescriptor.classCreator.getMethodCreator(GizmoSolutionClonerImplementor.getEntityHelperMethodName(entityClass), entityClass, new Class[]{entityClass, Map.class, Boolean.TYPE, ArrayDeque.class});
        methodCreator.setModifiers(9);
        ResultHandle toClone = methodCreator.getMethodParam(0);
        ResultHandle cloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = methodCreator.invokeInterfaceMethod(GET_METHOD, cloneMap, new ResultHandle[]{toClone});
        BranchResult hasCloneBranchResult = methodCreator.ifNotNull(maybeClone);
        try (BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();){
            hasCloneBranch.returnValue(maybeClone);
        }
        try (BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();){
            ResultHandle fallbackCloner = noCloneBranch.readStaticField(FieldDescriptor.of((String)GizmoSolutionClonerFactory.getGeneratedClassName(clonerDescriptor.solutionDescriptor), (String)FALLBACK_CLONER, FieldAccessingSolutionCloner.class));
            ResultHandle cloneObj = noCloneBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(FieldAccessingSolutionCloner.class, (String)"gizmoFallbackDeepClone", Object.class, (Class[])new Class[]{Object.class, Map.class}), fallbackCloner, new ResultHandle[]{toClone, cloneMap});
            noCloneBranch.returnValue(cloneObj);
        }
    }

    protected record ClonerDescriptor(SolutionDescriptor<?> solutionDescriptor, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet, ClassCreator classCreator) {
    }

    protected record ClonerMethodDescriptor(GizmoSolutionOrEntityDescriptor entityDescriptor, BytecodeCreator bytecodeCreator, ResultHandle createdCloneMap, boolean isBottom, ResultHandle cloneQueue) {
        public ClonerMethodDescriptor withBytecodeCreator(BytecodeCreator bytecodeCreator) {
            return new ClonerMethodDescriptor(this.entityDescriptor, bytecodeCreator, this.createdCloneMap, this.isBottom, this.cloneQueue);
        }

        public ClonerMethodDescriptor withCreatedCloneMap(ResultHandle createdCloneMap) {
            return new ClonerMethodDescriptor(this.entityDescriptor, this.bytecodeCreator, createdCloneMap, this.isBottom, this.cloneQueue);
        }

        public ClonerMethodDescriptor withCloneQueue(ResultHandle cloneQueue) {
            return new ClonerMethodDescriptor(this.entityDescriptor, this.bytecodeCreator, this.createdCloneMap, this.isBottom, cloneQueue);
        }
    }

    private static enum UnhandledCloneType {
        SHALLOW,
        DEEP;

    }
}

