/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.uni;

import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ForEachFilteredUniNode<A>
extends AbstractForEachUniNode<A> {
    private final Predicate<A> filter;

    public ForEachFilteredUniNode(Class<A> forEachClass, Predicate<A> filter, TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(forEachClass, nextNodesTupleLifecycle, outputStoreSize);
        this.filter = Objects.requireNonNull(filter);
    }

    @Override
    public void insert(@Nullable A a) {
        if (!this.filter.test(a)) {
            return;
        }
        super.insert(a);
    }

    @Override
    public void update(@Nullable A a) {
        UniTuple tuple = (UniTuple)this.tupleMap.get(a);
        if (tuple == null) {
            this.insert(a);
        } else if (this.filter.test(a)) {
            this.updateExisting(a, tuple);
        } else {
            this.retract(a);
        }
    }

    @Override
    public void retract(@Nullable A a) {
        UniTuple tuple = (UniTuple)this.tupleMap.remove(a);
        if (tuple == null) {
            return;
        }
        super.retractExisting(a, tuple);
    }

    @Override
    public boolean supports(AbstractForEachUniNode.LifecycleOperation lifecycleOperation) {
        return true;
    }
}

