/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListener;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.termination.AndCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.OrCompositeTermination;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
public interface UniversalTermination<Solution_>
extends PhaseTermination<Solution_>,
SolverTermination<Solution_>,
PhaseLifecycleListener<Solution_> {
    default public List<PhaseTermination<Solution_>> getPhaseTerminationList() {
        return Collections.emptyList();
    }

    default public List<Termination<Solution_>> getPhaseTerminationsInapplicableTo(Class<? extends AbstractPhaseScope> phaseScopeClass) {
        return this.getPhaseTerminationList().stream().filter(f -> !f.isApplicableTo(phaseScopeClass)).map(t -> t).toList();
    }

    @SafeVarargs
    public static <Solution_> @Nullable UniversalTermination<Solution_> or(Termination<Solution_> ... terminations) {
        if (terminations.length == 0) {
            return null;
        }
        return new OrCompositeTermination<Solution_>(terminations);
    }

    @SafeVarargs
    public static <Solution_> @Nullable UniversalTermination<Solution_> and(Termination<Solution_> ... terminations) {
        if (terminations.length == 0) {
            return null;
        }
        return new AndCompositeTermination<Solution_>(terminations);
    }
}

