/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.monitoring.statistic;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.monitoring.ScoreLevels;
import ai.timefold.solver.core.impl.solver.monitoring.SolverMetricUtil;
import ai.timefold.solver.core.impl.solver.monitoring.statistic.SolverStatistic;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class PickedMoveBestScoreDiffStatistic<Solution_, Score_ extends Score<Score_>>
implements SolverStatistic<Solution_> {
    private final Map<Solver<Solution_>, PhaseLifecycleListenerAdapter<Solution_>> solverToPhaseLifecycleListenerMap = new WeakHashMap<Solver<Solution_>, PhaseLifecycleListenerAdapter<Solution_>>();

    @Override
    public void unregister(Solver<Solution_> solver) {
        PhaseLifecycleListenerAdapter<Solution_> listener = this.solverToPhaseLifecycleListenerMap.remove(solver);
        if (listener != null) {
            ((DefaultSolver)solver).removePhaseLifecycleListener(listener);
        }
    }

    @Override
    public void register(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        ScoreDirectorFactory scoreDirectorFactory = defaultSolver.getScoreDirectorFactory();
        SolutionDescriptor solutionDescriptor = scoreDirectorFactory.getSolutionDescriptor();
        PickedMoveBestScoreDiffStatisticListener listener = new PickedMoveBestScoreDiffStatisticListener(solutionDescriptor.getScoreDefinition());
        this.solverToPhaseLifecycleListenerMap.put(solver, listener);
        defaultSolver.addPhaseLifecycleListener(listener);
    }

    private static class PickedMoveBestScoreDiffStatisticListener<Solution_, Score_ extends Score<Score_>>
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private Score_ oldBestScore = null;
        private final ScoreDefinition<Score_> scoreDefinition;
        private final Map<Tags, ScoreLevels> tagsToMoveScoreMap = new ConcurrentHashMap<Tags, ScoreLevels>();

        public PickedMoveBestScoreDiffStatisticListener(ScoreDefinition<Score_> scoreDefinition) {
            this.scoreDefinition = scoreDefinition;
        }

        @Override
        public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
            if (phaseScope instanceof LocalSearchPhaseScope) {
                this.oldBestScore = phaseScope.getBestScore().raw();
            }
        }

        @Override
        public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
            if (phaseScope instanceof LocalSearchPhaseScope) {
                this.oldBestScore = null;
            }
        }

        @Override
        public void stepEnded(AbstractStepScope<Solution_> stepScope) {
            if (stepScope instanceof LocalSearchStepScope) {
                this.localSearchStepEnded((LocalSearchStepScope)stepScope);
            }
        }

        private void localSearchStepEnded(LocalSearchStepScope<Solution_> stepScope) {
            if (stepScope.getBestScoreImproved()) {
                String moveType = stepScope.getStep().describe();
                Score_ newBestScore = stepScope.getScore().raw();
                Score_ bestScoreDiff = newBestScore.subtract(this.oldBestScore);
                this.oldBestScore = newBestScore;
                Tags tags = stepScope.getPhaseScope().getSolverScope().getMonitoringTags().and("move.type", moveType);
                SolverMetricUtil.registerScore(SolverMetric.PICKED_MOVE_TYPE_BEST_SCORE_DIFF, tags, this.scoreDefinition, this.tagsToMoveScoreMap, InnerScore.fullyAssigned(bestScoreDiff));
            }
        }
    }
}

