/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move;

import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class SwapMove<Solution_, Entity_>
extends AbstractMove<Solution_> {
    private final List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModelList;
    private final Entity_ leftEntity;
    private final Entity_ rightEntity;
    private @Nullable List<@Nullable Object> valueCache;

    public SwapMove(List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModelList, Entity_ leftEntity, Entity_ rightEntity) {
        this.variableMetaModelList = Objects.requireNonNull(variableMetaModelList);
        if (variableMetaModelList.isEmpty()) {
            throw new IllegalArgumentException("Swap move requires at least one planning variable to swap between entities, but got (%s).".formatted(variableMetaModelList));
        }
        this.leftEntity = Objects.requireNonNull(leftEntity);
        this.rightEntity = Objects.requireNonNull(rightEntity);
        if (leftEntity == rightEntity) {
            throw new IllegalArgumentException("Swap move requires two different entities (%s).".formatted(leftEntity));
        }
    }

    @Override
    public List<PlanningVariableMetaModel<Solution_, Entity_, Object>> variableMetaModels() {
        return this.variableMetaModelList;
    }

    public Entity_ getLeftEntity() {
        return this.leftEntity;
    }

    public Entity_ getRightEntity() {
        return this.rightEntity;
    }

    public SwapMove<Solution_, Entity_> rebase(Rebaser rebaser) {
        return new SwapMove<Solution_, Entity_>(this.variableMetaModelList, rebaser.rebase(this.leftEntity), rebaser.rebase(this.rightEntity));
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        List<Object> cachedValues = this.getCachedValues();
        for (int i = 0; i < cachedValues.size(); i += 2) {
            Object oldRightValue;
            PlanningVariableMetaModel<Solution_, Entity_, Object> variableMetaModel = this.variableMetaModelList.get(i / 2);
            Object oldLeftValue = cachedValues.get(i);
            if (Objects.equals(oldLeftValue, oldRightValue = cachedValues.get(i + 1)) || !solutionView.isValueInRange(variableMetaModel, this.leftEntity, oldRightValue) || !solutionView.isValueInRange(variableMetaModel, this.rightEntity, oldLeftValue)) continue;
            solutionView.changeVariable(variableMetaModel, this.leftEntity, oldRightValue);
            solutionView.changeVariable(variableMetaModel, this.rightEntity, oldLeftValue);
        }
    }

    private List<@Nullable Object> getCachedValues() {
        if (this.valueCache != null) {
            return this.valueCache;
        }
        this.valueCache = new ArrayList<Object>(this.variableMetaModelList.size() * 2);
        for (PlanningVariableMetaModel<Solution_, Entity_, Object> variableMetaModel : this.variableMetaModelList) {
            GenuineVariableDescriptor<Solution_> variableDescriptor = SwapMove.getVariableDescriptor(variableMetaModel);
            this.valueCache.add(variableDescriptor.getValue(this.leftEntity));
            this.valueCache.add(variableDescriptor.getValue(this.rightEntity));
        }
        return this.valueCache;
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        return List.of(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<@Nullable Object> extractPlanningValues() {
        return new LinkedHashSet<Object>(this.getCachedValues());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof SwapMove)) return false;
        SwapMove other = (SwapMove)o;
        if (!Objects.equals(this.variableMetaModelList, other.variableMetaModelList)) return false;
        if (!Objects.equals(this.leftEntity, other.leftEntity)) return false;
        if (!Objects.equals(this.rightEntity, other.rightEntity)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModelList, this.leftEntity, this.rightEntity);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.variableMetaModelList.size() * 16);
        s.append(this.leftEntity).append(" {");
        this.appendVariablesToString(s, true);
        s.append("} <-> ");
        s.append(this.rightEntity).append(" {");
        this.appendVariablesToString(s, false);
        s.append("}");
        return s.toString();
    }

    private void appendVariablesToString(StringBuilder s, boolean isLeftEntity) {
        List<Object> cachedValues = this.getCachedValues();
        for (int i = 0; i < cachedValues.size(); i += 2) {
            int index = isLeftEntity ? i : i + 1;
            Object value = cachedValues.get(index);
            if (i > 0) {
                s.append(", ");
            }
            s.append(value == null ? "null" : value.toString());
        }
    }
}

