/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.AbstractVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.AffectedEntitiesUpdater;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.jspecify.annotations.NonNull;

final class DefaultVariableReferenceGraph<Solution_>
extends AbstractVariableReferenceGraph<Solution_, BitSet> {
    private final AffectedEntitiesUpdater<Solution_> affectedEntitiesUpdater;

    public DefaultVariableReferenceGraph(VariableReferenceGraphBuilder<Solution_> outerGraph, IntFunction<TopologicalOrderGraph> graphCreator) {
        super(outerGraph, graphCreator);
        IdentityHashMap<Object, List> entityToVariableReferenceMap = new IdentityHashMap<Object, List>();
        for (GraphNode instance : this.nodeList) {
            if (instance.groupEntityIds() == null) {
                Object entity = instance.entity();
                entityToVariableReferenceMap.computeIfAbsent(entity, ignored -> new ArrayList()).add(instance);
                continue;
            }
            for (Object groupEntity : instance.variableReferences().get(0).groupEntities()) {
                entityToVariableReferenceMap.computeIfAbsent(groupEntity, ignored -> new ArrayList()).add(instance);
            }
        }
        Map immutableEntityToVariableReferenceMap = DefaultVariableReferenceGraph.mapOfListsDeepCopyOf(entityToVariableReferenceMap);
        this.affectedEntitiesUpdater = new AffectedEntitiesUpdater(this.graph, this.nodeList, immutableEntityToVariableReferenceMap::get, outerGraph.entityToEntityId.size(), outerGraph.changedVariableNotifier);
    }

    @Override
    protected BitSet createChangeSet(int instanceCount) {
        return new BitSet(instanceCount);
    }

    @Override
    public void markChanged(@NonNull GraphNode<Solution_> node) {
        ((BitSet)this.changeSet).set(node.graphNodeId());
    }

    @Override
    public void updateChanged() {
        if (((BitSet)this.changeSet).isEmpty()) {
            return;
        }
        this.graph.commitChanges((BitSet)this.changeSet);
        this.affectedEntitiesUpdater.accept((BitSet)this.changeSet);
    }

    public void setUnknownInconsistencyValues() {
        this.graph.commitChanges((BitSet)this.changeSet);
        this.affectedEntitiesUpdater.setUnknownInconsistencyValues();
    }
}

