/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSessionFactory;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityConsistencyState;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphStructure;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record ConsistencyTracker<Solution_>(IdentityHashMap<Object, Boolean> entityToIsInconsistentMap, HashMap<Class<?>, EntityConsistencyState<Solution_, Object>> entityClassToConsistencyStateMap, boolean isFrozen) {
    public ConsistencyTracker() {
        this(new IdentityHashMap<Object, Boolean>(), new HashMap(), false);
    }

    private ConsistencyTracker(boolean isFrozen) {
        this(new IdentityHashMap<Object, Boolean>(), new HashMap(), isFrozen);
    }

    public static <Solution_> ConsistencyTracker<Solution_> frozen(SolutionDescriptor<Solution_> solutionDescriptor, Object[] entityOrFacts) {
        ConsistencyTracker<Solution_> out = new ConsistencyTracker<Solution_>(true);
        out.setUnknownConsistencyFromEntityShadowVariablesInconsistent(solutionDescriptor, entityOrFacts);
        return out;
    }

    public EntityConsistencyState<Solution_, Object> getDeclarativeEntityConsistencyState(EntityDescriptor<Solution_> entityDescriptor) {
        return this.entityClassToConsistencyStateMap.computeIfAbsent(entityDescriptor.getEntityClass(), ignored -> new EntityConsistencyState(entityDescriptor, this.entityToIsInconsistentMap));
    }

    void setUnknownConsistencyFromEntityShadowVariablesInconsistent(SolutionDescriptor<Solution_> solutionDescriptor, Object[] entityOrFacts) {
        Object[] entities = Arrays.stream(entityOrFacts).filter(maybeEntity -> solutionDescriptor.hasEntityDescriptor(maybeEntity.getClass())).toArray(Object[]::new);
        VariableReferenceGraph graph = DefaultShadowVariableSessionFactory.buildGraphForStructureAndDirection(new GraphStructure.GraphStructureAndDirection(GraphStructure.ARBITRARY, null, null), new DefaultShadowVariableSessionFactory.GraphDescriptor<Solution_>(solutionDescriptor, ChangedVariableNotifier.empty(), entities).withConsistencyTracker(this));
        if (graph instanceof DefaultVariableReferenceGraph) {
            DefaultVariableReferenceGraph defaultVariableReferenceGraph = (DefaultVariableReferenceGraph)graph;
            defaultVariableReferenceGraph.setUnknownInconsistencyValues();
        }
    }
}

