/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.composite;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.util.ValueRangeIterator;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import java.util.Iterator;
import java.util.Random;
import org.jspecify.annotations.NonNull;

public final class NullAllowingCountableValueRange<T>
extends AbstractCountableValueRange<T> {
    private final AbstractCountableValueRange<T> childValueRange;
    private final long size;

    public NullAllowingCountableValueRange(CountableValueRange<T> childValueRange) {
        this.childValueRange = (AbstractCountableValueRange)childValueRange;
        if (childValueRange instanceof NullAllowingCountableValueRange) {
            throw new IllegalArgumentException("Impossible state: The childValueRange (%s) must not be a %s, because it is already wrapped in one.".formatted(childValueRange, NullAllowingCountableValueRange.class.getSimpleName()));
        }
        this.size = childValueRange.getSize() + 1L;
    }

    @Override
    public boolean isValueImmutable() {
        return super.isValueImmutable();
    }

    AbstractCountableValueRange<T> getChildValueRange() {
        return this.childValueRange;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public T get(long index) {
        if (index == 0L) {
            return null;
        }
        return this.childValueRange.get(index - 1L);
    }

    @Override
    public boolean contains(T value) {
        if (value == null) {
            return true;
        }
        return this.childValueRange.contains(value);
    }

    @Override
    public @NonNull Iterator<T> createOriginalIterator() {
        return new OriginalNullValueRangeIterator(this.childValueRange.createOriginalIterator());
    }

    @Override
    public @NonNull Iterator<T> createRandomIterator(@NonNull Random workingRandom) {
        return new RandomNullValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[null]\u222a" + String.valueOf(this.childValueRange);
    }

    private class OriginalNullValueRangeIterator
    extends ValueRangeIterator<T> {
        private boolean nullReturned = false;
        private final Iterator<T> childIterator;

        public OriginalNullValueRangeIterator(Iterator<T> childIterator) {
            this.childIterator = childIterator;
        }

        @Override
        public boolean hasNext() {
            return !this.nullReturned || this.childIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.nullReturned) {
                this.nullReturned = true;
                return null;
            }
            return this.childIterator.next();
        }
    }

    private class RandomNullValueRangeIterator
    extends ValueRangeIterator<T> {
        private final Random workingRandom;

        public RandomNullValueRangeIterator(Random workingRandom) {
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            long index = RandomUtils.nextLong(this.workingRandom, NullAllowingCountableValueRange.this.size);
            return NullAllowingCountableValueRange.this.get(index);
        }
    }
}

