/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.ExistsCounter;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;

public abstract class AbstractIndexedIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft;
    private final IndexerFactory.UniKeysExtractor<Right_> keysExtractorRight;
    private final int inputStoreIndexLeftKeys;
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightKeys;
    private final int inputStoreIndexRightEntry;
    private final Indexer<ExistsCounter<LeftTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedIfExistsNode(boolean shouldExist, IndexerFactory.KeysExtractor<LeftTuple_> keysExtractorLeft, IndexerFactory<Right_> indexerFactory, int inputStoreIndexLeftKeys, int inputStoreIndexLeftCounterEntry, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightKeys, int inputStoreIndexRightEntry, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering) {
        super(shouldExist, inputStoreIndexLeftTrackerList, inputStoreIndexRightTrackerList, nextNodesTupleLifecycle, isFiltering);
        this.keysExtractorLeft = keysExtractorLeft;
        this.keysExtractorRight = indexerFactory.buildRightKeysExtractor();
        this.inputStoreIndexLeftKeys = inputStoreIndexLeftKeys;
        this.inputStoreIndexLeftCounterEntry = inputStoreIndexLeftCounterEntry;
        this.inputStoreIndexRightKeys = inputStoreIndexRightKeys;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
        this.indexerLeft = indexerFactory.buildIndexer(true);
        this.indexerRight = indexerFactory.buildIndexer(false);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftKeys) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(leftTuple) + ") was already added in the tupleStore.");
        }
        Object indexKeys = this.keysExtractorLeft.apply(leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftKeys, indexKeys);
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        ElementAwareListEntry<ExistsCounter<LeftTuple_>> counterEntry = this.indexerLeft.put(indexKeys, counter);
        this.updateCounterRight(leftTuple, indexKeys, counter, counterEntry);
        this.initCounterLeft(counter);
    }

    private void updateCounterRight(LeftTuple_ leftTuple, Object indexKeys, ExistsCounter<LeftTuple_> counter, ElementAwareListEntry<ExistsCounter<LeftTuple_>> counterEntry) {
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
        if (!this.isFiltering) {
            counter.countRight = this.indexerRight.size(indexKeys);
        } else {
            ElementAwareList leftTrackerList = new ElementAwareList();
            this.indexerRight.forEach(indexKeys, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        Object oldIndexKeys = ((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftKeys);
        if (oldIndexKeys == null) {
            this.insertLeft(leftTuple);
            return;
        }
        Object newIndexKeys = this.keysExtractorLeft.apply(leftTuple);
        ElementAwareListEntry counterEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (oldIndexKeys.equals(newIndexKeys)) {
            if (!this.isFiltering) {
                this.updateUnchangedCounterLeft(counter);
            } else {
                ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
                leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
                counter.countRight = 0;
                this.indexerRight.forEach(oldIndexKeys, rightTuple -> this.updateCounterFromLeft(leftTuple, rightTuple, counter, leftTrackerList));
                this.updateCounterLeft(counter);
            }
        } else {
            this.updateIndexerLeft(oldIndexKeys, counterEntry, leftTuple);
            counter.countRight = 0;
            ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftKeys, newIndexKeys);
            this.updateCounterRight(leftTuple, newIndexKeys, counter, this.indexerLeft.put(newIndexKeys, counter));
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        Object indexKeys = ((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftKeys);
        if (indexKeys == null) {
            return;
        }
        ElementAwareListEntry counterEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftCounterEntry);
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        this.updateIndexerLeft(indexKeys, counterEntry, leftTuple);
        this.killCounterLeft(counter);
    }

    private void updateIndexerLeft(Object indexKeys, ElementAwareListEntry<ExistsCounter<LeftTuple_>> counterEntry, LeftTuple_ leftTuple) {
        this.indexerLeft.remove(indexKeys, counterEntry);
        if (this.isFiltering) {
            ElementAwareList leftTrackerList = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightKeys) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + String.valueOf(rightTuple) + ") was already added in the tupleStore.");
        }
        Object indexKeys = this.keysExtractorRight.apply(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightKeys, indexKeys);
        ElementAwareListEntry<UniTuple<Right_>> rightEntry = this.indexerRight.put(indexKeys, rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        this.updateCounterLeft(rightTuple, indexKeys);
    }

    private void updateCounterLeft(UniTuple<Right_> rightTuple, Object indexKeys) {
        if (!this.isFiltering) {
            this.indexerLeft.forEach(indexKeys, this::incrementCounterRight);
        } else {
            ElementAwareList rightTrackerList = new ElementAwareList();
            this.indexerLeft.forEach(indexKeys, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        Object oldIndexKeys = rightTuple.getStore(this.inputStoreIndexRightKeys);
        if (oldIndexKeys == null) {
            this.insertRight(rightTuple);
            return;
        }
        Object newIndexKeys = this.keysExtractorRight.apply(rightTuple);
        if (oldIndexKeys.equals(newIndexKeys)) {
            if (this.isFiltering) {
                ElementAwareList rightTrackerList = this.updateRightTrackerList(rightTuple);
                this.indexerLeft.forEach(oldIndexKeys, counter -> this.updateCounterFromRight(rightTuple, counter, rightTrackerList));
            }
        } else {
            ElementAwareListEntry<UniTuple<Right_>> rightEntry = (ElementAwareListEntry<UniTuple<Right_>>)rightTuple.getStore(this.inputStoreIndexRightEntry);
            this.indexerRight.remove(oldIndexKeys, rightEntry);
            if (!this.isFiltering) {
                this.indexerLeft.forEach(oldIndexKeys, this::decrementCounterRight);
            } else {
                this.updateRightTrackerList(rightTuple);
            }
            rightTuple.setStore(this.inputStoreIndexRightKeys, newIndexKeys);
            rightEntry = this.indexerRight.put(newIndexKeys, rightTuple);
            rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
            this.updateCounterLeft(rightTuple, newIndexKeys);
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        Object indexKeys = rightTuple.removeStore(this.inputStoreIndexRightKeys);
        if (indexKeys == null) {
            return;
        }
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        this.indexerRight.remove(indexKeys, rightEntry);
        if (!this.isFiltering) {
            this.indexerLeft.forEach(indexKeys, this::decrementCounterRight);
        } else {
            this.updateRightTrackerList(rightTuple);
        }
    }
}

