/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedAssignment;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.impl.domain.variable.ShadowVariableUpdateHelper;
import ai.timefold.solver.core.impl.solver.DefaultSolutionManager;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningSolutionDiff;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface SolutionManager<Solution_, Score_ extends Score<Score_>> {
    public static <Solution_, Score_ extends Score<Score_>> SolutionManager<Solution_, Score_> create(SolverFactory<Solution_> solverFactory) {
        return new DefaultSolutionManager(solverFactory);
    }

    public static <Solution_, Score_ extends Score<Score_>, ProblemId_> SolutionManager<Solution_, Score_> create(SolverManager<Solution_, ProblemId_> solverManager) {
        return new DefaultSolutionManager(solverManager);
    }

    default public @Nullable Score_ update(Solution_ solution) {
        return this.update(solution, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public @Nullable Score_ update(Solution_ var1, SolutionUpdatePolicy var2);

    public static <Solution_> void updateShadowVariables(Class<Solution_> solutionClass, Object ... entities) {
        if (Objects.requireNonNull(entities).length == 0) {
            throw new IllegalArgumentException("The entity array cannot be empty.");
        }
        ShadowVariableUpdateHelper.create().updateShadowVariables(solutionClass, entities);
    }

    public static <Solution_> void updateShadowVariables(Solution_ solution) {
        ShadowVariableUpdateHelper.create().updateShadowVariables(solution);
    }

    default public ScoreExplanation<Solution_, Score_> explain(Solution_ solution) {
        return this.explain(solution, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public ScoreExplanation<Solution_, Score_> explain(Solution_ var1, SolutionUpdatePolicy var2);

    default public ScoreAnalysis<Score_> analyze(Solution_ solution) {
        return this.analyze(solution, ScoreAnalysisFetchPolicy.FETCH_ALL, SolutionUpdatePolicy.UPDATE_ALL);
    }

    default public ScoreAnalysis<Score_> analyze(Solution_ solution, ScoreAnalysisFetchPolicy fetchPolicy) {
        return this.analyze(solution, fetchPolicy, SolutionUpdatePolicy.UPDATE_ALL);
    }

    public ScoreAnalysis<Score_> analyze(Solution_ var1, ScoreAnalysisFetchPolicy var2, SolutionUpdatePolicy var3);

    public PlanningSolutionDiff<Solution_> diff(Solution_ var1, Solution_ var2);

    default public <EntityOrElement_, Proposition_> List<RecommendedAssignment<Proposition_, Score_>> recommendAssignment(Solution_ solution, EntityOrElement_ evaluatedEntityOrElement, Function<EntityOrElement_, @Nullable Proposition_> propositionFunction) {
        return this.recommendAssignment(solution, evaluatedEntityOrElement, propositionFunction, ScoreAnalysisFetchPolicy.FETCH_ALL);
    }

    public <EntityOrElement_, Proposition_> List<RecommendedAssignment<Proposition_, Score_>> recommendAssignment(Solution_ var1, EntityOrElement_ var2, Function<EntityOrElement_, @Nullable Proposition_> var3, ScoreAnalysisFetchPolicy var4);

    @Deprecated(forRemoval=true, since="1.15.0")
    default public <EntityOrElement_, Proposition_> List<RecommendedFit<Proposition_, Score_>> recommendFit(Solution_ solution, EntityOrElement_ fittedEntityOrElement, Function<EntityOrElement_, @Nullable Proposition_> propositionFunction) {
        return this.recommendFit(solution, fittedEntityOrElement, propositionFunction, ScoreAnalysisFetchPolicy.FETCH_ALL);
    }

    @Deprecated(forRemoval=true, since="1.15.0")
    public <EntityOrElement_, Proposition_> List<RecommendedFit<Proposition_, Score_>> recommendFit(Solution_ var1, EntityOrElement_ var2, Function<EntityOrElement_, @Nullable Proposition_> var3, ScoreAnalysisFetchPolicy var4);
}

