/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.preview.api.domain.metamodel;

import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.ShadowVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface PlanningEntityMetaModel<Solution_, Entity_> {
    public PlanningSolutionMetaModel<Solution_> solution();

    public Class<Entity_> type();

    public List<VariableMetaModel<Solution_, Entity_, ?>> variables();

    default public List<GenuineVariableMetaModel<Solution_, Entity_, ?>> genuineVariables() {
        return this.variables().stream().filter(VariableMetaModel::isGenuine).map(v -> (GenuineVariableMetaModel)v).toList();
    }

    default public <Value_> GenuineVariableMetaModel<Solution_, Entity_, Value_> genuineVariable() {
        List<GenuineVariableMetaModel<Solution_, Entity_, ?>> genuineVariables = this.genuineVariables();
        switch (genuineVariables.size()) {
            case 0: {
                throw new IllegalStateException("The entity class (%s) has no genuine variables.".formatted(this.type().getCanonicalName()));
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("The entity class (%s) has multiple genuine variables (%s).".formatted(this.type().getCanonicalName(), genuineVariables));
            }
        }
        return genuineVariables.get(0);
    }

    default public <Value_> GenuineVariableMetaModel<Solution_, Entity_, Value_> genuineVariable(String variableName) {
        VariableMetaModel<Solution_, Entity_, Value_> variable = this.variable(variableName);
        if (!variable.isGenuine()) {
            throw new IllegalArgumentException("The variableName (%s) exists among variables (%s) but is not genuine.".formatted(variableName, this.variables()));
        }
        return (GenuineVariableMetaModel)variable;
    }

    default public <Value_> VariableMetaModel<Solution_, Entity_, Value_> variable(String variableName) {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.name().equals(variableName)) continue;
            return variableMetaModel;
        }
        throw new IllegalArgumentException("The variableName (%s) does not exist in the variables (%s).".formatted(variableName, this.variables()));
    }

    default public boolean hasVariable(String variableName) {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.name().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    default public <Value_> PlanningVariableMetaModel<Solution_, Entity_, Value_> planningVariable() {
        return (PlanningVariableMetaModel)this.genuineVariable();
    }

    default public <Value_> PlanningVariableMetaModel<Solution_, Entity_, Value_> planningVariable(String variableName) {
        return (PlanningVariableMetaModel)this.variable(variableName);
    }

    default public <Value_> PlanningListVariableMetaModel<Solution_, Entity_, Value_> planningListVariable() {
        return (PlanningListVariableMetaModel)this.genuineVariable();
    }

    default public <Value_> PlanningListVariableMetaModel<Solution_, Entity_, Value_> planningListVariable(String variableName) {
        return (PlanningListVariableMetaModel)this.variable(variableName);
    }

    default public <Value_> ShadowVariableMetaModel<Solution_, Entity_, Value_> shadowVariable(String variableName) {
        return (ShadowVariableMetaModel)this.variable(variableName);
    }

    default public boolean isGenuine() {
        for (VariableMetaModel<Solution_, Entity_, ?> variableMetaModel : this.variables()) {
            if (!variableMetaModel.isGenuine()) continue;
            return true;
        }
        return false;
    }
}

