/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.provider;

import ai.timefold.solver.core.impl.move.streams.maybeapi.DataJoiners;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.ListSwapMove;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.provider.UniquePair;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProducer;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveProvider;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamFactory;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniDataStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ListSwapMoveProvider<Solution_, Entity_, Value_>
implements MoveProvider<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;

    public ListSwapMoveProvider(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
    }

    @Override
    public MoveProducer<Solution_> apply(MoveStreamFactory<Solution_> moveStreamFactory) {
        UniDataStream<Solution_, Object> assignedValueStream = moveStreamFactory.enumerate(this.variableMetaModel.type(), false).filter((solutionView, value) -> solutionView.getPositionOf(this.variableMetaModel, value) instanceof PositionInList);
        BiDataStream validAssignedValuePairStream = assignedValueStream.join(assignedValueStream, DataJoiners.filtering((solutionView, leftValue, rightValue) -> !Objects.equals(leftValue, rightValue)));
        BiDataStream validAssignedValueUniquePairStream = validAssignedValuePairStream.map((solutionView, leftValue, rightValue) -> new UniquePair<Object>(leftValue, rightValue)).distinct().map((solutionView, pair) -> FullElementPosition.of(this.variableMetaModel, solutionView, pair.first()), (solutionView, pair) -> FullElementPosition.of(this.variableMetaModel, solutionView, pair.second()));
        BiDataStream<Solution_, FullElementPosition, FullElementPosition> result = validAssignedValueUniquePairStream.filter((solutionView, leftPosition, rightPosition) -> solutionView.isValueInRange(this.variableMetaModel, rightPosition.entity(), leftPosition.value()) && solutionView.isValueInRange(this.variableMetaModel, leftPosition.entity(), rightPosition.value()));
        return moveStreamFactory.pick(result).asMove((solutionView, leftPosition, rightPosition) -> new ListSwapMove<Solution_, Entity_, Value_>(this.variableMetaModel, leftPosition.entity(), leftPosition.index(), rightPosition.entity(), rightPosition.index()));
    }

    private record FullElementPosition<Entity_, Value_>(Value_ value, Entity_ entity, int index) {
        public static <Solution_, Entity_, Value_> FullElementPosition<Entity_, Value_> of(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, SolutionView<Solution_> solutionView, Value_ value) {
            PositionInList assignedElement = solutionView.getPositionOf(variableMetaModel, value).ensureAssigned();
            return new FullElementPosition(value, assignedElement.entity(), assignedElement.index());
        }
    }
}

