/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move;

import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CompositeMove<Solution_>
implements Move<Solution_> {
    private final Move<Solution_>[] moves;

    @SafeVarargs
    public static <Solution_, Move_ extends Move<Solution_>> Move<Solution_> buildMove(Move_ ... moves) {
        return switch (moves.length) {
            case 0 -> throw new UnsupportedOperationException("The CompositeMove cannot be built from an empty move list.");
            case 1 -> moves[0];
            default -> new CompositeMove<Solution_>((Move<Solution_>[])moves);
        };
    }

    public static <Solution_, Move_ extends Move<Solution_>> Move<Solution_> buildMove(List<Move_> moveList) {
        return CompositeMove.buildMove((Move[])moveList.toArray(new Move[0]));
    }

    private CompositeMove(Move<Solution_>[] moves) {
        this.moves = moves;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        for (Move<Solution_> move : this.moves) {
            move.execute(solutionView);
        }
    }

    @Override
    public Move<Solution_> rebase(Rebaser rebaser) {
        Move[] rebasedMoves = new Move[this.moves.length];
        for (int i = 0; i < this.moves.length; ++i) {
            rebasedMoves[i] = this.moves[i].rebase(rebaser);
        }
        return new CompositeMove<Solution_>(rebasedMoves);
    }

    @Override
    public Collection<?> extractPlanningEntities() {
        Set entities = CollectionUtils.newLinkedHashSet(this.moves.length * 2);
        for (Move<Solution_> move : this.moves) {
            entities.addAll(move.extractPlanningEntities());
        }
        return entities;
    }

    @Override
    public Collection<@Nullable Object> extractPlanningValues() {
        Set<Object> values = CollectionUtils.newLinkedHashSet(this.moves.length * 2);
        for (Move<Solution_> move : this.moves) {
            values.addAll(move.extractPlanningValues());
        }
        return values;
    }

    @Override
    public String describe() {
        return this.getClass().getSimpleName() + Arrays.stream(this.moves).map(Move::describe).sorted().map(childMoveTypeDescription -> "* " + childMoveTypeDescription).collect(Collectors.joining(",", "(", ")"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof CompositeMove)) return false;
        CompositeMove that = (CompositeMove)o;
        if (!Objects.deepEquals(this.moves, that.moves)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.moves);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.moves);
    }
}

