/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi;

import ai.timefold.solver.core.impl.bavet.common.joiner.JoinerType;
import ai.timefold.solver.core.impl.move.streams.dataset.joiner.DefaultBiDataJoiner;
import ai.timefold.solver.core.impl.move.streams.dataset.joiner.FilteringBiDataJoiner;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataFilter;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataJoiner;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DataJoiners {
    public static <A> BiDataJoiner<A, A> equal() {
        return DataJoiners.equal(ConstantLambdaUtils.identity());
    }

    public static <A, Property_> BiDataJoiner<A, A> equal(Function<A, Property_> mapping) {
        return DataJoiners.equal(mapping, mapping);
    }

    public static <A, B, Property_> BiDataJoiner<A, B> equal(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiDataJoiner<A, B>(leftMapping, JoinerType.EQUAL, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> BiDataJoiner<A, A> lessThan(Function<A, Property_> mapping) {
        return DataJoiners.lessThan(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> BiDataJoiner<A, B> lessThan(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiDataJoiner<A, B>(leftMapping, JoinerType.LESS_THAN, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> BiDataJoiner<A, A> lessThanOrEqual(Function<A, Property_> mapping) {
        return DataJoiners.lessThanOrEqual(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> BiDataJoiner<A, B> lessThanOrEqual(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiDataJoiner<A, B>(leftMapping, JoinerType.LESS_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> BiDataJoiner<A, A> greaterThan(Function<A, Property_> mapping) {
        return DataJoiners.greaterThan(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> BiDataJoiner<A, B> greaterThan(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiDataJoiner<A, B>(leftMapping, JoinerType.GREATER_THAN, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> BiDataJoiner<A, A> greaterThanOrEqual(Function<A, Property_> mapping) {
        return DataJoiners.greaterThanOrEqual(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> BiDataJoiner<A, B> greaterThanOrEqual(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiDataJoiner<A, B>(leftMapping, JoinerType.GREATER_THAN_OR_EQUAL, rightMapping);
    }

    public static <Solution_, A, B> BiDataJoiner<A, B> filtering(BiDataFilter<Solution_, A, B> filter) {
        return new FilteringBiDataJoiner<Solution_, A, B>(filter);
    }

    public static <A, Property_ extends Comparable<Property_>> BiDataJoiner<A, A> overlapping(Function<A, Property_> startMapping, Function<A, Property_> endMapping) {
        return DataJoiners.overlapping(startMapping, endMapping, startMapping, endMapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> BiDataJoiner<A, B> overlapping(Function<A, Property_> leftStartMapping, Function<A, Property_> leftEndMapping, Function<B, Property_> rightStartMapping, Function<B, Property_> rightEndMapping) {
        return DataJoiners.lessThan(leftStartMapping, rightEndMapping).and(DataJoiners.greaterThan(leftEndMapping, rightStartMapping));
    }

    private DataJoiners() {
    }
}

