/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset.joiner;

import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.impl.move.streams.dataset.joiner.DefaultBiDataJoiner;
import ai.timefold.solver.core.impl.move.streams.dataset.joiner.FilteringBiDataJoiner;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataFilter;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataJoiner;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record BiDataJoinerComber<Solution_, A, B>(DefaultBiDataJoiner<A, B> mergedJoiner, @Nullable BiDataFilter<Solution_, A, B> mergedFiltering) {
    public static <Solution_, A, B> BiDataJoinerComber<Solution_, A, B> comb(BiDataJoiner<A, B>[] joiners) {
        ArrayList defaultJoinerList = new ArrayList(joiners.length);
        ArrayList<BiDataFilter<Solution_, A, B>> filteringList = new ArrayList<BiDataFilter<Solution_, A, B>>(joiners.length);
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joiners.length; ++i) {
            BiDataJoiner<A, B> joiner = joiners[i];
            if (joiner instanceof FilteringBiDataJoiner) {
                indexOfFirstFilter = i;
                filteringList.add(((FilteringBiDataJoiner)joiner).filter());
                continue;
            }
            if (joiner instanceof DefaultBiDataJoiner) {
                if (indexOfFirstFilter >= 0) {
                    throw new IllegalStateException("Indexing joiner (%s) must not follow a filtering joiner (%s).\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.".formatted(joiner, joiners[indexOfFirstFilter]));
                }
                defaultJoinerList.add((DefaultBiDataJoiner)joiner);
                continue;
            }
            throw new IllegalArgumentException("The joiner class (%s) is not supported.".formatted(joiner.getClass().getSimpleName()));
        }
        DefaultBiDataJoiner mergedJoiner = DefaultBiDataJoiner.merge(defaultJoinerList);
        BiDataFilter<Solution_, A, B> mergedFiltering = BiDataJoinerComber.mergeFiltering(filteringList);
        return new BiDataJoinerComber(mergedJoiner, mergedFiltering);
    }

    private static <Solution_, A, B> @Nullable BiDataFilter<Solution_, A, B> mergeFiltering(List<BiDataFilter<Solution_, A, B>> filteringList) {
        if (filteringList.isEmpty()) {
            return null;
        }
        return switch (filteringList.size()) {
            case 1 -> filteringList.get(0);
            case 2 -> filteringList.get(0).and((TriPredicate)filteringList.get(1));
            default -> (solutionView, a, b) -> {
                for (BiDataFilter predicate : filteringList) {
                    if (predicate.test(solutionView, a, b)) continue;
                    return false;
                }
                return true;
            };
        };
    }
}

