/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset.bi;

import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.bi.AbstractBiDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.common.DataNodeBuildHelper;
import ai.timefold.solver.core.impl.move.streams.maybeapi.BiDataFilter;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class FilterBiDataStream<Solution_, A, B>
extends AbstractBiDataStream<Solution_, A, B> {
    private final BiDataFilter<Solution_, A, B> filter;

    public FilterBiDataStream(DataStreamFactory<Solution_> dataStreamFactory, AbstractBiDataStream<Solution_, A, B> parent, BiDataFilter<Solution_, A, B> filter) {
        super(dataStreamFactory, parent);
        this.filter = Objects.requireNonNull(filter, "The filter cannot be null.");
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        BiPredicate predicate = this.filter.toBiPredicate(buildHelper.getSessionContext().solutionView());
        buildHelper.putInsertUpdateRetract(this, this.childStreamList, tupleLifecycle -> TupleLifecycle.conditionally(tupleLifecycle, predicate));
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof FilterBiDataStream)) return false;
        FilterBiDataStream other = (FilterBiDataStream)o;
        if (this.parent != other.parent) return false;
        if (this.filter != other.filter) return false;
        return true;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }
}

